/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.AthenaException;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.GetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.GetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.InternalServerException;
import software.amazon.awssdk.services.athena.model.InvalidRequestException;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.TooManyRequestsException;
import software.amazon.awssdk.services.athena.paginators.GetQueryResultsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListNamedQueriesPublisher;
import software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsPublisher;
import software.amazon.awssdk.services.athena.transform.BatchGetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetNamedQueryResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetQueryExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNamedQueryResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNamedQueryResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.GetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNamedQueryResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryResultsResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.ListNamedQueriesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNamedQueriesResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.ListQueryExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListQueryExecutionsResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.StartQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartQueryExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.athena.transform.StopQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopQueryExecutionResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultAthenaAsyncClient
implements AthenaAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAthenaAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultAthenaAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "athena";
    }

    @Override
    public CompletableFuture<BatchGetNamedQueryResponse> batchGetNamedQuery(BatchGetNamedQueryRequest batchGetNamedQueryRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetNamedQueryResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new BatchGetNamedQueryRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetNamedQueryRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetQueryExecutionResponse> batchGetQueryExecution(BatchGetQueryExecutionRequest batchGetQueryExecutionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetQueryExecutionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new BatchGetQueryExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetQueryExecutionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateNamedQueryResponse> createNamedQuery(CreateNamedQueryRequest createNamedQueryRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNamedQueryResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateNamedQueryRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNamedQueryRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteNamedQueryResponse> deleteNamedQuery(DeleteNamedQueryRequest deleteNamedQueryRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNamedQueryResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteNamedQueryRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNamedQueryRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetNamedQueryResponse> getNamedQuery(GetNamedQueryRequest getNamedQueryRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNamedQueryResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetNamedQueryRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNamedQueryRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueryExecutionResponse> getQueryExecution(GetQueryExecutionRequest getQueryExecutionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQueryExecutionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetQueryExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueryExecutionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQueryResultsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetQueryResultsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueryResultsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetQueryResultsPublisher getQueryResultsPaginator(GetQueryResultsRequest getQueryResultsRequest) {
        return new GetQueryResultsPublisher(this, this.applyPaginatorUserAgent(getQueryResultsRequest));
    }

    @Override
    public CompletableFuture<ListNamedQueriesResponse> listNamedQueries(ListNamedQueriesRequest listNamedQueriesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNamedQueriesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListNamedQueriesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNamedQueriesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListNamedQueriesPublisher listNamedQueriesPaginator(ListNamedQueriesRequest listNamedQueriesRequest) {
        return new ListNamedQueriesPublisher(this, this.applyPaginatorUserAgent(listNamedQueriesRequest));
    }

    @Override
    public CompletableFuture<ListQueryExecutionsResponse> listQueryExecutions(ListQueryExecutionsRequest listQueryExecutionsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQueryExecutionsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListQueryExecutionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQueryExecutionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListQueryExecutionsPublisher listQueryExecutionsPaginator(ListQueryExecutionsRequest listQueryExecutionsRequest) {
        return new ListQueryExecutionsPublisher(this, this.applyPaginatorUserAgent(listQueryExecutionsRequest));
    }

    @Override
    public CompletableFuture<StartQueryExecutionResponse> startQueryExecution(StartQueryExecutionRequest startQueryExecutionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartQueryExecutionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StartQueryExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startQueryExecutionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopQueryExecutionResponse> stopQueryExecution(StopQueryExecutionRequest stopQueryExecutionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopQueryExecutionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StopQueryExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopQueryExecutionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(AthenaException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private <T extends AthenaRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AthenaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

