/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResultSetMetadataMarshaller {
    private static final MarshallingInfo<List> COLUMNINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColumnInfo").isBinary(false).build();
    private static final ResultSetMetadataMarshaller INSTANCE = new ResultSetMetadataMarshaller();

    private ResultSetMetadataMarshaller() {
    }

    public static ResultSetMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResultSetMetadata resultSetMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resultSetMetadata, (String)"resultSetMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(resultSetMetadata.columnInfo(), COLUMNINFO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

