/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResultConfigurationMarshaller {
    private static final MarshallingInfo<String> OUTPUTLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputLocation").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionConfiguration").isBinary(false).build();
    private static final ResultConfigurationMarshaller INSTANCE = new ResultConfigurationMarshaller();

    private ResultConfigurationMarshaller() {
    }

    public static ResultConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResultConfiguration resultConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resultConfiguration, (String)"resultConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resultConfiguration.outputLocation(), OUTPUTLOCATION_BINDING);
            protocolMarshaller.marshall((Object)resultConfiguration.encryptionConfiguration(), ENCRYPTIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

