/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.QueryExecutionContext;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QueryExecutionContextMarshaller {
    private static final MarshallingInfo<String> DATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").isBinary(false).build();
    private static final QueryExecutionContextMarshaller INSTANCE = new QueryExecutionContextMarshaller();

    private QueryExecutionContextMarshaller() {
    }

    public static QueryExecutionContextMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QueryExecutionContext queryExecutionContext, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)queryExecutionContext, (String)"queryExecutionContext");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)queryExecutionContext.database(), DATABASE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

