/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.NamedQuery;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NamedQueryMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").isBinary(false).build();
    private static final MarshallingInfo<String> QUERYSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryString").isBinary(false).build();
    private static final MarshallingInfo<String> NAMEDQUERYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamedQueryId").isBinary(false).build();
    private static final NamedQueryMarshaller INSTANCE = new NamedQueryMarshaller();

    private NamedQueryMarshaller() {
    }

    public static NamedQueryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NamedQuery namedQuery, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)namedQuery, (String)"namedQuery");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)namedQuery.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)namedQuery.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)namedQuery.database(), DATABASE_BINDING);
            protocolMarshaller.marshall((Object)namedQuery.queryString(), QUERYSTRING_BINDING);
            protocolMarshaller.marshall((Object)namedQuery.namedQueryId(), NAMEDQUERYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

