/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.Datum;
import software.amazon.awssdk.services.athena.model._datumListCopier;
import software.amazon.awssdk.services.athena.transform.RowMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Row
implements StructuredPojo,
ToCopyableBuilder<Builder, Row> {
    private final List<Datum> data;

    private Row(BuilderImpl builder) {
        this.data = builder.data;
    }

    public List<Datum> data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row)obj;
        return Objects.equals(this.data(), other.data());
    }

    public String toString() {
        return ToString.builder((String)"Row").add("Data", this.data()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.of(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RowMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Datum> data;

        private BuilderImpl() {
        }

        private BuilderImpl(Row model) {
            this.data(model.data);
        }

        public final Collection<Datum.Builder> getData() {
            return this.data != null ? (Collection)this.data.stream().map(Datum::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder data(Collection<Datum> data) {
            this.data = _datumListCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Datum ... data) {
            this.data(Arrays.asList(data));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Consumer<Datum.Builder> ... data) {
            this.data(Stream.of(data).map(c -> (Datum)((Datum.Builder)Datum.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setData(Collection<Datum.BuilderImpl> data) {
            this.data = _datumListCopier.copyFromBuilder(data);
        }

        public Row build() {
            return new Row(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Row> {
        public Builder data(Collection<Datum> var1);

        public Builder data(Datum ... var1);

        public Builder data(Consumer<Datum.Builder> ... var1);
    }
}

