/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.services.athena.transform.ResultConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResultConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ResultConfiguration> {
    private final String outputLocation;
    private final EncryptionConfiguration encryptionConfiguration;

    private ResultConfiguration(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public String outputLocation() {
        return this.outputLocation;
    }

    public EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultConfiguration)) {
            return false;
        }
        ResultConfiguration other = (ResultConfiguration)obj;
        return Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"ResultConfiguration").add("OutputLocation", (Object)this.outputLocation()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputLocation": {
                return Optional.of(clazz.cast(this.outputLocation()));
            }
            case "EncryptionConfiguration": {
                return Optional.of(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputLocation;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultConfiguration model) {
            this.outputLocation(model.outputLocation);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getOutputLocation() {
            return this.outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public ResultConfiguration build() {
            return new ResultConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResultConfiguration> {
        public Builder outputLocation(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().apply(encryptionConfiguration)).build());
        }
    }
}

