/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.ResultSet;

@SdkInternalApi
public class ResultSetMarshaller {
    private static final MarshallingInfo<List> ROWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rows").build();
    private static final MarshallingInfo<StructuredPojo> RESULTSETMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultSetMetadata").build();
    private static final ResultSetMarshaller instance = new ResultSetMarshaller();

    public static ResultSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResultSet resultSet, ProtocolMarshaller protocolMarshaller) {
        if (resultSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resultSet.rows(), ROWS_BINDING);
            protocolMarshaller.marshall((Object)resultSet.resultSetMetadata(), RESULTSETMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

