/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.artifact.ArtifactClient;
import software.amazon.awssdk.services.artifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.artifact.model.CustomerAgreementSummary;
import software.amazon.awssdk.services.artifact.model.ListCustomerAgreementsRequest;
import software.amazon.awssdk.services.artifact.model.ListCustomerAgreementsResponse;

public class ListCustomerAgreementsIterable
implements SdkIterable<ListCustomerAgreementsResponse> {
    private final ArtifactClient client;
    private final ListCustomerAgreementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomerAgreementsIterable(ArtifactClient client, ListCustomerAgreementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomerAgreementsResponseFetcher();
    }

    public Iterator<ListCustomerAgreementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomerAgreementSummary> customerAgreements() {
        Function<ListCustomerAgreementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customerAgreements() != null) {
                return response.customerAgreements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomerAgreementsResponseFetcher
    implements SyncPageFetcher<ListCustomerAgreementsResponse> {
        private ListCustomerAgreementsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomerAgreementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomerAgreementsResponse nextPage(ListCustomerAgreementsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomerAgreementsIterable.this.client.listCustomerAgreements(ListCustomerAgreementsIterable.this.firstRequest);
            }
            return ListCustomerAgreementsIterable.this.client.listCustomerAgreements((ListCustomerAgreementsRequest)((Object)ListCustomerAgreementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

