/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.artifact.ArtifactAsyncClient;
import software.amazon.awssdk.services.artifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.artifact.model.CustomerAgreementSummary;
import software.amazon.awssdk.services.artifact.model.ListCustomerAgreementsRequest;
import software.amazon.awssdk.services.artifact.model.ListCustomerAgreementsResponse;

public class ListCustomerAgreementsPublisher
implements SdkPublisher<ListCustomerAgreementsResponse> {
    private final ArtifactAsyncClient client;
    private final ListCustomerAgreementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomerAgreementsPublisher(ArtifactAsyncClient client, ListCustomerAgreementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomerAgreementsPublisher(ArtifactAsyncClient client, ListCustomerAgreementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomerAgreementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomerAgreementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomerAgreementSummary> customerAgreements() {
        Function<ListCustomerAgreementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customerAgreements() != null) {
                return response.customerAgreements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomerAgreementsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomerAgreementsResponseFetcher
    implements AsyncPageFetcher<ListCustomerAgreementsResponse> {
        private ListCustomerAgreementsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomerAgreementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomerAgreementsResponse> nextPage(ListCustomerAgreementsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomerAgreementsPublisher.this.client.listCustomerAgreements(ListCustomerAgreementsPublisher.this.firstRequest);
            }
            return ListCustomerAgreementsPublisher.this.client.listCustomerAgreements((ListCustomerAgreementsRequest)((Object)ListCustomerAgreementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

