/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.artifact.ArtifactClient;
import software.amazon.awssdk.services.artifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.artifact.model.ListReportsRequest;
import software.amazon.awssdk.services.artifact.model.ListReportsResponse;
import software.amazon.awssdk.services.artifact.model.ReportSummary;

public class ListReportsIterable
implements SdkIterable<ListReportsResponse> {
    private final ArtifactClient client;
    private final ListReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReportsIterable(ArtifactClient client, ListReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReportsResponseFetcher();
    }

    public Iterator<ListReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReportSummary> reports() {
        Function<ListReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reports() != null) {
                return response.reports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReportsResponseFetcher
    implements SyncPageFetcher<ListReportsResponse> {
        private ListReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReportsResponse nextPage(ListReportsResponse previousPage) {
            if (previousPage == null) {
                return ListReportsIterable.this.client.listReports(ListReportsIterable.this.firstRequest);
            }
            return ListReportsIterable.this.client.listReports((ListReportsRequest)((Object)ListReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

