/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ShiftType {
    ZONAL_SHIFT("ZONAL_SHIFT"),
    PRACTICE_RUN("PRACTICE_RUN"),
    FIS_EXPERIMENT("FIS_EXPERIMENT"),
    ZONAL_AUTOSHIFT("ZONAL_AUTOSHIFT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ShiftType> VALUE_MAP;
    private final String value;

    private ShiftType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ShiftType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ShiftType> knownValues() {
        EnumSet<ShiftType> knownValues = EnumSet.allOf(ShiftType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ShiftType.class, ShiftType::toString);
    }
}

