/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arczonalshift.model.ArcZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.model.ZonalAutoshiftStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateZonalAutoshiftConfigurationResponse
extends ArcZonalShiftResponse
implements ToCopyableBuilder<Builder, UpdateZonalAutoshiftConfigurationResponse> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceIdentifier").getter(UpdateZonalAutoshiftConfigurationResponse.getter(UpdateZonalAutoshiftConfigurationResponse::resourceIdentifier)).setter(UpdateZonalAutoshiftConfigurationResponse.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<String> ZONAL_AUTOSHIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zonalAutoshiftStatus").getter(UpdateZonalAutoshiftConfigurationResponse.getter(UpdateZonalAutoshiftConfigurationResponse::zonalAutoshiftStatusAsString)).setter(UpdateZonalAutoshiftConfigurationResponse.setter(Builder::zonalAutoshiftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalAutoshiftStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD, ZONAL_AUTOSHIFT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
            this.put("zonalAutoshiftStatus", ZONAL_AUTOSHIFT_STATUS_FIELD);
        }
    });
    private final String resourceIdentifier;
    private final String zonalAutoshiftStatus;

    private UpdateZonalAutoshiftConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.zonalAutoshiftStatus = builder.zonalAutoshiftStatus;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final ZonalAutoshiftStatus zonalAutoshiftStatus() {
        return ZonalAutoshiftStatus.fromValue(this.zonalAutoshiftStatus);
    }

    public final String zonalAutoshiftStatusAsString() {
        return this.zonalAutoshiftStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalAutoshiftStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateZonalAutoshiftConfigurationResponse)) {
            return false;
        }
        UpdateZonalAutoshiftConfigurationResponse other = (UpdateZonalAutoshiftConfigurationResponse)((Object)obj);
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.zonalAutoshiftStatusAsString(), other.zonalAutoshiftStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateZonalAutoshiftConfigurationResponse").add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ZonalAutoshiftStatus", (Object)this.zonalAutoshiftStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "zonalAutoshiftStatus": {
                return Optional.ofNullable(clazz.cast(this.zonalAutoshiftStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateZonalAutoshiftConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateZonalAutoshiftConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcZonalShiftResponse.BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private String zonalAutoshiftStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateZonalAutoshiftConfigurationResponse model) {
            super(model);
            this.resourceIdentifier(model.resourceIdentifier);
            this.zonalAutoshiftStatus(model.zonalAutoshiftStatus);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getZonalAutoshiftStatus() {
            return this.zonalAutoshiftStatus;
        }

        public final void setZonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
        }

        @Override
        public final Builder zonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
            return this;
        }

        @Override
        public final Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus(zonalAutoshiftStatus == null ? null : zonalAutoshiftStatus.toString());
            return this;
        }

        @Override
        public UpdateZonalAutoshiftConfigurationResponse build() {
            return new UpdateZonalAutoshiftConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ArcZonalShiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateZonalAutoshiftConfigurationResponse> {
        public Builder resourceIdentifier(String var1);

        public Builder zonalAutoshiftStatus(String var1);

        public Builder zonalAutoshiftStatus(ZonalAutoshiftStatus var1);
    }
}

