/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ControlConditionType {
    CLOUDWATCH("CLOUDWATCH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ControlConditionType> VALUE_MAP;
    private final String value;

    private ControlConditionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlConditionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlConditionType> knownValues() {
        EnumSet<ControlConditionType> knownValues = EnumSet.allOf(ControlConditionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ControlConditionType.class, ControlConditionType::toString);
    }
}

