/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arczonalshift.model.AppliedStatus;
import software.amazon.awssdk.services.arczonalshift.model.PracticeRunOutcome;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ZonalShiftInResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ZonalShiftInResource> {
    private static final SdkField<String> APPLIED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appliedStatus").getter(ZonalShiftInResource.getter(ZonalShiftInResource::appliedStatusAsString)).setter(ZonalShiftInResource.setter(Builder::appliedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedStatus").build()}).build();
    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awayFrom").getter(ZonalShiftInResource.getter(ZonalShiftInResource::awayFrom)).setter(ZonalShiftInResource.setter(Builder::awayFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(ZonalShiftInResource.getter(ZonalShiftInResource::comment)).setter(ZonalShiftInResource.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiryTime").getter(ZonalShiftInResource.getter(ZonalShiftInResource::expiryTime)).setter(ZonalShiftInResource.setter(Builder::expiryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()}).build();
    private static final SdkField<String> PRACTICE_RUN_OUTCOME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("practiceRunOutcome").getter(ZonalShiftInResource.getter(ZonalShiftInResource::practiceRunOutcomeAsString)).setter(ZonalShiftInResource.setter(Builder::practiceRunOutcome)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("practiceRunOutcome").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceIdentifier").getter(ZonalShiftInResource.getter(ZonalShiftInResource::resourceIdentifier)).setter(ZonalShiftInResource.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ZonalShiftInResource.getter(ZonalShiftInResource::startTime)).setter(ZonalShiftInResource.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> ZONAL_SHIFT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zonalShiftId").getter(ZonalShiftInResource.getter(ZonalShiftInResource::zonalShiftId)).setter(ZonalShiftInResource.setter(Builder::zonalShiftId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShiftId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLIED_STATUS_FIELD, AWAY_FROM_FIELD, COMMENT_FIELD, EXPIRY_TIME_FIELD, PRACTICE_RUN_OUTCOME_FIELD, RESOURCE_IDENTIFIER_FIELD, START_TIME_FIELD, ZONAL_SHIFT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appliedStatus;
    private final String awayFrom;
    private final String comment;
    private final Instant expiryTime;
    private final String practiceRunOutcome;
    private final String resourceIdentifier;
    private final Instant startTime;
    private final String zonalShiftId;

    private ZonalShiftInResource(BuilderImpl builder) {
        this.appliedStatus = builder.appliedStatus;
        this.awayFrom = builder.awayFrom;
        this.comment = builder.comment;
        this.expiryTime = builder.expiryTime;
        this.practiceRunOutcome = builder.practiceRunOutcome;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.startTime = builder.startTime;
        this.zonalShiftId = builder.zonalShiftId;
    }

    public final AppliedStatus appliedStatus() {
        return AppliedStatus.fromValue(this.appliedStatus);
    }

    public final String appliedStatusAsString() {
        return this.appliedStatus;
    }

    public final String awayFrom() {
        return this.awayFrom;
    }

    public final String comment() {
        return this.comment;
    }

    public final Instant expiryTime() {
        return this.expiryTime;
    }

    public final PracticeRunOutcome practiceRunOutcome() {
        return PracticeRunOutcome.fromValue(this.practiceRunOutcome);
    }

    public final String practiceRunOutcomeAsString() {
        return this.practiceRunOutcome;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String zonalShiftId() {
        return this.zonalShiftId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.practiceRunOutcomeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalShiftId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZonalShiftInResource)) {
            return false;
        }
        ZonalShiftInResource other = (ZonalShiftInResource)obj;
        return Objects.equals(this.appliedStatusAsString(), other.appliedStatusAsString()) && Objects.equals(this.awayFrom(), other.awayFrom()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.expiryTime(), other.expiryTime()) && Objects.equals(this.practiceRunOutcomeAsString(), other.practiceRunOutcomeAsString()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.zonalShiftId(), other.zonalShiftId());
    }

    public final String toString() {
        return ToString.builder((String)"ZonalShiftInResource").add("AppliedStatus", (Object)this.appliedStatusAsString()).add("AwayFrom", (Object)this.awayFrom()).add("Comment", (Object)this.comment()).add("ExpiryTime", (Object)this.expiryTime()).add("PracticeRunOutcome", (Object)this.practiceRunOutcomeAsString()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("StartTime", (Object)this.startTime()).add("ZonalShiftId", (Object)this.zonalShiftId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appliedStatus": {
                return Optional.ofNullable(clazz.cast(this.appliedStatusAsString()));
            }
            case "awayFrom": {
                return Optional.ofNullable(clazz.cast(this.awayFrom()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "expiryTime": {
                return Optional.ofNullable(clazz.cast(this.expiryTime()));
            }
            case "practiceRunOutcome": {
                return Optional.ofNullable(clazz.cast(this.practiceRunOutcomeAsString()));
            }
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "zonalShiftId": {
                return Optional.ofNullable(clazz.cast(this.zonalShiftId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ZonalShiftInResource, T> g) {
        return obj -> g.apply((ZonalShiftInResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appliedStatus;
        private String awayFrom;
        private String comment;
        private Instant expiryTime;
        private String practiceRunOutcome;
        private String resourceIdentifier;
        private Instant startTime;
        private String zonalShiftId;

        private BuilderImpl() {
        }

        private BuilderImpl(ZonalShiftInResource model) {
            this.appliedStatus(model.appliedStatus);
            this.awayFrom(model.awayFrom);
            this.comment(model.comment);
            this.expiryTime(model.expiryTime);
            this.practiceRunOutcome(model.practiceRunOutcome);
            this.resourceIdentifier(model.resourceIdentifier);
            this.startTime(model.startTime);
            this.zonalShiftId(model.zonalShiftId);
        }

        public final String getAppliedStatus() {
            return this.appliedStatus;
        }

        public final void setAppliedStatus(String appliedStatus) {
            this.appliedStatus = appliedStatus;
        }

        @Override
        public final Builder appliedStatus(String appliedStatus) {
            this.appliedStatus = appliedStatus;
            return this;
        }

        @Override
        public final Builder appliedStatus(AppliedStatus appliedStatus) {
            this.appliedStatus(appliedStatus == null ? null : appliedStatus.toString());
            return this;
        }

        public final String getAwayFrom() {
            return this.awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getExpiryTime() {
            return this.expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final String getPracticeRunOutcome() {
            return this.practiceRunOutcome;
        }

        public final void setPracticeRunOutcome(String practiceRunOutcome) {
            this.practiceRunOutcome = practiceRunOutcome;
        }

        @Override
        public final Builder practiceRunOutcome(String practiceRunOutcome) {
            this.practiceRunOutcome = practiceRunOutcome;
            return this;
        }

        @Override
        public final Builder practiceRunOutcome(PracticeRunOutcome practiceRunOutcome) {
            this.practiceRunOutcome(practiceRunOutcome == null ? null : practiceRunOutcome.toString());
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getZonalShiftId() {
            return this.zonalShiftId;
        }

        public final void setZonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
        }

        @Override
        public final Builder zonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
            return this;
        }

        public ZonalShiftInResource build() {
            return new ZonalShiftInResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ZonalShiftInResource> {
        public Builder appliedStatus(String var1);

        public Builder appliedStatus(AppliedStatus var1);

        public Builder awayFrom(String var1);

        public Builder comment(String var1);

        public Builder expiryTime(Instant var1);

        public Builder practiceRunOutcome(String var1);

        public Builder practiceRunOutcome(PracticeRunOutcome var1);

        public Builder resourceIdentifier(String var1);

        public Builder startTime(Instant var1);

        public Builder zonalShiftId(String var1);
    }
}

