/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arczonalshift.model.AutoshiftAppliedStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoshiftInResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoshiftInResource> {
    private static final SdkField<String> APPLIED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appliedStatus").getter(AutoshiftInResource.getter(AutoshiftInResource::appliedStatusAsString)).setter(AutoshiftInResource.setter(Builder::appliedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedStatus").build()}).build();
    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awayFrom").getter(AutoshiftInResource.getter(AutoshiftInResource::awayFrom)).setter(AutoshiftInResource.setter(Builder::awayFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(AutoshiftInResource.getter(AutoshiftInResource::startTime)).setter(AutoshiftInResource.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLIED_STATUS_FIELD, AWAY_FROM_FIELD, START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appliedStatus;
    private final String awayFrom;
    private final Instant startTime;

    private AutoshiftInResource(BuilderImpl builder) {
        this.appliedStatus = builder.appliedStatus;
        this.awayFrom = builder.awayFrom;
        this.startTime = builder.startTime;
    }

    public final AutoshiftAppliedStatus appliedStatus() {
        return AutoshiftAppliedStatus.fromValue(this.appliedStatus);
    }

    public final String appliedStatusAsString() {
        return this.appliedStatus;
    }

    public final String awayFrom() {
        return this.awayFrom;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoshiftInResource)) {
            return false;
        }
        AutoshiftInResource other = (AutoshiftInResource)obj;
        return Objects.equals(this.appliedStatusAsString(), other.appliedStatusAsString()) && Objects.equals(this.awayFrom(), other.awayFrom()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"AutoshiftInResource").add("AppliedStatus", (Object)this.appliedStatusAsString()).add("AwayFrom", (Object)this.awayFrom()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appliedStatus": {
                return Optional.ofNullable(clazz.cast(this.appliedStatusAsString()));
            }
            case "awayFrom": {
                return Optional.ofNullable(clazz.cast(this.awayFrom()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoshiftInResource, T> g) {
        return obj -> g.apply((AutoshiftInResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appliedStatus;
        private String awayFrom;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoshiftInResource model) {
            this.appliedStatus(model.appliedStatus);
            this.awayFrom(model.awayFrom);
            this.startTime(model.startTime);
        }

        public final String getAppliedStatus() {
            return this.appliedStatus;
        }

        public final void setAppliedStatus(String appliedStatus) {
            this.appliedStatus = appliedStatus;
        }

        @Override
        public final Builder appliedStatus(String appliedStatus) {
            this.appliedStatus = appliedStatus;
            return this;
        }

        @Override
        public final Builder appliedStatus(AutoshiftAppliedStatus appliedStatus) {
            this.appliedStatus(appliedStatus == null ? null : appliedStatus.toString());
            return this;
        }

        public final String getAwayFrom() {
            return this.awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public AutoshiftInResource build() {
            return new AutoshiftInResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoshiftInResource> {
        public Builder appliedStatus(String var1);

        public Builder appliedStatus(AutoshiftAppliedStatus var1);

        public Builder awayFrom(String var1);

        public Builder startTime(Instant var1);
    }
}

