/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftClient;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftServiceClientConfiguration;
import software.amazon.awssdk.services.arczonalshift.model.AccessDeniedException;
import software.amazon.awssdk.services.arczonalshift.model.ArcZonalShiftException;
import software.amazon.awssdk.services.arczonalshift.model.ArcZonalShiftRequest;
import software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftRequest;
import software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.model.ConflictException;
import software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceRequest;
import software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceResponse;
import software.amazon.awssdk.services.arczonalshift.model.InternalServerException;
import software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse;
import software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse;
import software.amazon.awssdk.services.arczonalshift.model.ResourceNotFoundException;
import software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftRequest;
import software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.model.ThrottlingException;
import software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftRequest;
import software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftResponse;
import software.amazon.awssdk.services.arczonalshift.model.ValidationException;
import software.amazon.awssdk.services.arczonalshift.paginators.ListManagedResourcesIterable;
import software.amazon.awssdk.services.arczonalshift.paginators.ListZonalShiftsIterable;
import software.amazon.awssdk.services.arczonalshift.transform.CancelZonalShiftRequestMarshaller;
import software.amazon.awssdk.services.arczonalshift.transform.GetManagedResourceRequestMarshaller;
import software.amazon.awssdk.services.arczonalshift.transform.ListManagedResourcesRequestMarshaller;
import software.amazon.awssdk.services.arczonalshift.transform.ListZonalShiftsRequestMarshaller;
import software.amazon.awssdk.services.arczonalshift.transform.StartZonalShiftRequestMarshaller;
import software.amazon.awssdk.services.arczonalshift.transform.UpdateZonalShiftRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultArcZonalShiftClient
implements ArcZonalShiftClient {
    private static final Logger log = Logger.loggerFor(DefaultArcZonalShiftClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ArcZonalShiftServiceClientConfiguration serviceClientConfiguration;

    protected DefaultArcZonalShiftClient(ArcZonalShiftServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelZonalShiftResponse cancelZonalShift(CancelZonalShiftRequest cancelZonalShiftRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ArcZonalShiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelZonalShiftResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultArcZonalShiftClient.resolveMetricPublishers(this.clientConfiguration, cancelZonalShiftRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ARC Zonal Shift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelZonalShift");
            CancelZonalShiftResponse cancelZonalShiftResponse = (CancelZonalShiftResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelZonalShift").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelZonalShiftRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelZonalShiftRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelZonalShiftResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultArcZonalShiftClient.lambda$cancelZonalShift$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetManagedResourceResponse getManagedResource(GetManagedResourceRequest getManagedResourceRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ArcZonalShiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetManagedResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultArcZonalShiftClient.resolveMetricPublishers(this.clientConfiguration, getManagedResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ARC Zonal Shift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetManagedResource");
            GetManagedResourceResponse getManagedResourceResponse = (GetManagedResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetManagedResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getManagedResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetManagedResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getManagedResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultArcZonalShiftClient.lambda$getManagedResource$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListManagedResourcesResponse listManagedResources(ListManagedResourcesRequest listManagedResourcesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ArcZonalShiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListManagedResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultArcZonalShiftClient.resolveMetricPublishers(this.clientConfiguration, listManagedResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ARC Zonal Shift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListManagedResources");
            ListManagedResourcesResponse listManagedResourcesResponse = (ListManagedResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListManagedResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listManagedResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListManagedResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listManagedResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultArcZonalShiftClient.lambda$listManagedResources$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListManagedResourcesIterable listManagedResourcesPaginator(ListManagedResourcesRequest listManagedResourcesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ArcZonalShiftException {
        return new ListManagedResourcesIterable(this, this.applyPaginatorUserAgent(listManagedResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListZonalShiftsResponse listZonalShifts(ListZonalShiftsRequest listZonalShiftsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ArcZonalShiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListZonalShiftsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultArcZonalShiftClient.resolveMetricPublishers(this.clientConfiguration, listZonalShiftsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ARC Zonal Shift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListZonalShifts");
            ListZonalShiftsResponse listZonalShiftsResponse = (ListZonalShiftsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListZonalShifts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listZonalShiftsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListZonalShiftsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listZonalShiftsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultArcZonalShiftClient.lambda$listZonalShifts$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListZonalShiftsIterable listZonalShiftsPaginator(ListZonalShiftsRequest listZonalShiftsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ArcZonalShiftException {
        return new ListZonalShiftsIterable(this, this.applyPaginatorUserAgent(listZonalShiftsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartZonalShiftResponse startZonalShift(StartZonalShiftRequest startZonalShiftRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ArcZonalShiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartZonalShiftResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultArcZonalShiftClient.resolveMetricPublishers(this.clientConfiguration, startZonalShiftRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ARC Zonal Shift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartZonalShift");
            StartZonalShiftResponse startZonalShiftResponse = (StartZonalShiftResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartZonalShift").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startZonalShiftRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartZonalShiftRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startZonalShiftResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultArcZonalShiftClient.lambda$startZonalShift$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateZonalShiftResponse updateZonalShift(UpdateZonalShiftRequest updateZonalShiftRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ArcZonalShiftException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateZonalShiftResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultArcZonalShiftClient.resolveMetricPublishers(this.clientConfiguration, updateZonalShiftRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ARC Zonal Shift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateZonalShift");
            UpdateZonalShiftResponse updateZonalShiftResponse = (UpdateZonalShiftResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateZonalShift").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateZonalShiftRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateZonalShiftRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateZonalShiftResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultArcZonalShiftClient.lambda$updateZonalShift$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends ArcZonalShiftRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.72").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ArcZonalShiftRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "arc-zonal-shift";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ArcZonalShiftException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    @Override
    public final ArcZonalShiftServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateZonalShift$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startZonalShift$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listZonalShifts$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listManagedResources$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getManagedResource$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelZonalShift$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

