/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftAsyncClient;
import software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse;
import software.amazon.awssdk.services.arczonalshift.model.ZonalShiftSummary;

public class ListZonalShiftsPublisher
implements SdkPublisher<ListZonalShiftsResponse> {
    private final ArcZonalShiftAsyncClient client;
    private final ListZonalShiftsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListZonalShiftsPublisher(ArcZonalShiftAsyncClient client, ListZonalShiftsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListZonalShiftsPublisher(ArcZonalShiftAsyncClient client, ListZonalShiftsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListZonalShiftsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListZonalShiftsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ZonalShiftSummary> items() {
        Function<ListZonalShiftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListZonalShiftsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListZonalShiftsResponseFetcher
    implements AsyncPageFetcher<ListZonalShiftsResponse> {
        private ListZonalShiftsResponseFetcher() {
        }

        public boolean hasNextPage(ListZonalShiftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListZonalShiftsResponse> nextPage(ListZonalShiftsResponse previousPage) {
            if (previousPage == null) {
                return ListZonalShiftsPublisher.this.client.listZonalShifts(ListZonalShiftsPublisher.this.firstRequest);
            }
            return ListZonalShiftsPublisher.this.client.listZonalShifts((ListZonalShiftsRequest)((Object)ListZonalShiftsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

