/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftClient;
import software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse;
import software.amazon.awssdk.services.arczonalshift.model.ZonalShiftSummary;

public class ListZonalShiftsIterable
implements SdkIterable<ListZonalShiftsResponse> {
    private final ArcZonalShiftClient client;
    private final ListZonalShiftsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListZonalShiftsIterable(ArcZonalShiftClient client, ListZonalShiftsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListZonalShiftsResponseFetcher();
    }

    public Iterator<ListZonalShiftsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ZonalShiftSummary> items() {
        Function<ListZonalShiftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListZonalShiftsResponseFetcher
    implements SyncPageFetcher<ListZonalShiftsResponse> {
        private ListZonalShiftsResponseFetcher() {
        }

        public boolean hasNextPage(ListZonalShiftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListZonalShiftsResponse nextPage(ListZonalShiftsResponse previousPage) {
            if (previousPage == null) {
                return ListZonalShiftsIterable.this.client.listZonalShifts(ListZonalShiftsIterable.this.firstRequest);
            }
            return ListZonalShiftsIterable.this.client.listZonalShifts((ListZonalShiftsRequest)((Object)ListZonalShiftsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

