/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.ReportOutputConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.ReportOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportConfiguration> {
    private static final SdkField<List<ReportOutputConfiguration>> REPORT_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reportOutput").getter(ReportConfiguration.getter(ReportConfiguration::reportOutput)).setter(ReportConfiguration.setter(Builder::reportOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ReportOutputConfiguration> reportOutput;

    private ReportConfiguration(BuilderImpl builder) {
        this.reportOutput = builder.reportOutput;
    }

    public final boolean hasReportOutput() {
        return this.reportOutput != null && !(this.reportOutput instanceof SdkAutoConstructList);
    }

    public final List<ReportOutputConfiguration> reportOutput() {
        return this.reportOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportOutput() ? this.reportOutput() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportConfiguration)) {
            return false;
        }
        ReportConfiguration other = (ReportConfiguration)obj;
        return this.hasReportOutput() == other.hasReportOutput() && Objects.equals(this.reportOutput(), other.reportOutput());
    }

    public final String toString() {
        return ToString.builder((String)"ReportConfiguration").add("ReportOutput", this.hasReportOutput() ? this.reportOutput() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportOutput": {
                return Optional.ofNullable(clazz.cast(this.reportOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ReportOutputConfiguration>>> map = new HashMap<String, SdkField<List<ReportOutputConfiguration>>>();
        map.put("reportOutput", REPORT_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportConfiguration, T> g) {
        return obj -> g.apply((ReportConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ReportOutputConfiguration> reportOutput = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReportConfiguration model) {
            this.reportOutput(model.reportOutput);
        }

        public final List<ReportOutputConfiguration.Builder> getReportOutput() {
            List<ReportOutputConfiguration.Builder> result = ReportOutputListCopier.copyToBuilder(this.reportOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReportOutput(Collection<ReportOutputConfiguration.BuilderImpl> reportOutput) {
            this.reportOutput = ReportOutputListCopier.copyFromBuilder(reportOutput);
        }

        @Override
        public final Builder reportOutput(Collection<ReportOutputConfiguration> reportOutput) {
            this.reportOutput = ReportOutputListCopier.copy(reportOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportOutput(ReportOutputConfiguration ... reportOutput) {
            this.reportOutput(Arrays.asList(reportOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportOutput(Consumer<ReportOutputConfiguration.Builder> ... reportOutput) {
            this.reportOutput(Stream.of(reportOutput).map(c -> (ReportOutputConfiguration)((ReportOutputConfiguration.Builder)ReportOutputConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReportConfiguration build() {
            return new ReportConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportConfiguration> {
        public Builder reportOutput(Collection<ReportOutputConfiguration> var1);

        public Builder reportOutput(ReportOutputConfiguration ... var1);

        public Builder reportOutput(Consumer<ReportOutputConfiguration.Builder> ... var1);
    }
}

