/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchResponse;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionAction;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionMode;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionState;
import software.amazon.awssdk.services.arcregionswitch.model.GeneratedReport;
import software.amazon.awssdk.services.arcregionswitch.model.GeneratedReportDetailsCopier;
import software.amazon.awssdk.services.arcregionswitch.model.Plan;
import software.amazon.awssdk.services.arcregionswitch.model.StepState;
import software.amazon.awssdk.services.arcregionswitch.model.StepStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPlanExecutionResponse
extends ArcRegionSwitchResponse
implements ToCopyableBuilder<Builder, GetPlanExecutionResponse> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planArn").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::planArn)).setter(GetPlanExecutionResponse.setter(Builder::planArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::executionId)).setter(GetPlanExecutionResponse.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::version)).setter(GetPlanExecutionResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::updatedAt)).setter(GetPlanExecutionResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::comment)).setter(GetPlanExecutionResponse.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::startTime)).setter(GetPlanExecutionResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::endTime)).setter(GetPlanExecutionResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::modeAsString)).setter(GetPlanExecutionResponse.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<String> EXECUTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionState").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::executionStateAsString)).setter(GetPlanExecutionResponse.setter(Builder::executionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionState").build()}).build();
    private static final SdkField<String> EXECUTION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionAction").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::executionActionAsString)).setter(GetPlanExecutionResponse.setter(Builder::executionAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionAction").build()}).build();
    private static final SdkField<String> EXECUTION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRegion").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::executionRegion)).setter(GetPlanExecutionResponse.setter(Builder::executionRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRegion").build()}).build();
    private static final SdkField<List<StepState>> STEP_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stepStates").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::stepStates)).setter(GetPlanExecutionResponse.setter(Builder::stepStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Plan> PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("plan").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::plan)).setter(GetPlanExecutionResponse.setter(Builder::plan)).constructor(Plan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plan").build()}).build();
    private static final SdkField<String> ACTUAL_RECOVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actualRecoveryTime").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::actualRecoveryTime)).setter(GetPlanExecutionResponse.setter(Builder::actualRecoveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualRecoveryTime").build()}).build();
    private static final SdkField<List<GeneratedReport>> GENERATED_REPORT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("generatedReportDetails").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::generatedReportDetails)).setter(GetPlanExecutionResponse.setter(Builder::generatedReportDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedReportDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeneratedReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetPlanExecutionResponse.getter(GetPlanExecutionResponse::nextToken)).setter(GetPlanExecutionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD, EXECUTION_ID_FIELD, VERSION_FIELD, UPDATED_AT_FIELD, COMMENT_FIELD, START_TIME_FIELD, END_TIME_FIELD, MODE_FIELD, EXECUTION_STATE_FIELD, EXECUTION_ACTION_FIELD, EXECUTION_REGION_FIELD, STEP_STATES_FIELD, PLAN_FIELD, ACTUAL_RECOVERY_TIME_FIELD, GENERATED_REPORT_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPlanExecutionResponse.memberNameToFieldInitializer();
    private final String planArn;
    private final String executionId;
    private final String version;
    private final Instant updatedAt;
    private final String comment;
    private final Instant startTime;
    private final Instant endTime;
    private final String mode;
    private final String executionState;
    private final String executionAction;
    private final String executionRegion;
    private final List<StepState> stepStates;
    private final Plan plan;
    private final String actualRecoveryTime;
    private final List<GeneratedReport> generatedReportDetails;
    private final String nextToken;

    private GetPlanExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.executionId = builder.executionId;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
        this.comment = builder.comment;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.mode = builder.mode;
        this.executionState = builder.executionState;
        this.executionAction = builder.executionAction;
        this.executionRegion = builder.executionRegion;
        this.stepStates = builder.stepStates;
        this.plan = builder.plan;
        this.actualRecoveryTime = builder.actualRecoveryTime;
        this.generatedReportDetails = builder.generatedReportDetails;
        this.nextToken = builder.nextToken;
    }

    public final String planArn() {
        return this.planArn;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String version() {
        return this.version;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String comment() {
        return this.comment;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final ExecutionState executionState() {
        return ExecutionState.fromValue(this.executionState);
    }

    public final String executionStateAsString() {
        return this.executionState;
    }

    public final ExecutionAction executionAction() {
        return ExecutionAction.fromValue(this.executionAction);
    }

    public final String executionActionAsString() {
        return this.executionAction;
    }

    public final String executionRegion() {
        return this.executionRegion;
    }

    public final boolean hasStepStates() {
        return this.stepStates != null && !(this.stepStates instanceof SdkAutoConstructList);
    }

    public final List<StepState> stepStates() {
        return this.stepStates;
    }

    public final Plan plan() {
        return this.plan;
    }

    public final String actualRecoveryTime() {
        return this.actualRecoveryTime;
    }

    public final boolean hasGeneratedReportDetails() {
        return this.generatedReportDetails != null && !(this.generatedReportDetails instanceof SdkAutoConstructList);
    }

    public final List<GeneratedReport> generatedReportDetails() {
        return this.generatedReportDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.planArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepStates() ? this.stepStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.plan());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualRecoveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeneratedReportDetails() ? this.generatedReportDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlanExecutionResponse)) {
            return false;
        }
        GetPlanExecutionResponse other = (GetPlanExecutionResponse)((Object)obj);
        return Objects.equals(this.planArn(), other.planArn()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.executionStateAsString(), other.executionStateAsString()) && Objects.equals(this.executionActionAsString(), other.executionActionAsString()) && Objects.equals(this.executionRegion(), other.executionRegion()) && this.hasStepStates() == other.hasStepStates() && Objects.equals(this.stepStates(), other.stepStates()) && Objects.equals(this.plan(), other.plan()) && Objects.equals(this.actualRecoveryTime(), other.actualRecoveryTime()) && this.hasGeneratedReportDetails() == other.hasGeneratedReportDetails() && Objects.equals(this.generatedReportDetails(), other.generatedReportDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetPlanExecutionResponse").add("PlanArn", (Object)this.planArn()).add("ExecutionId", (Object)this.executionId()).add("Version", (Object)this.version()).add("UpdatedAt", (Object)this.updatedAt()).add("Comment", (Object)this.comment()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Mode", (Object)this.modeAsString()).add("ExecutionState", (Object)this.executionStateAsString()).add("ExecutionAction", (Object)this.executionActionAsString()).add("ExecutionRegion", (Object)this.executionRegion()).add("StepStates", this.hasStepStates() ? this.stepStates() : null).add("Plan", (Object)this.plan()).add("ActualRecoveryTime", (Object)this.actualRecoveryTime()).add("GeneratedReportDetails", this.hasGeneratedReportDetails() ? this.generatedReportDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "planArn": {
                return Optional.ofNullable(clazz.cast(this.planArn()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "executionState": {
                return Optional.ofNullable(clazz.cast(this.executionStateAsString()));
            }
            case "executionAction": {
                return Optional.ofNullable(clazz.cast(this.executionActionAsString()));
            }
            case "executionRegion": {
                return Optional.ofNullable(clazz.cast(this.executionRegion()));
            }
            case "stepStates": {
                return Optional.ofNullable(clazz.cast(this.stepStates()));
            }
            case "plan": {
                return Optional.ofNullable(clazz.cast(this.plan()));
            }
            case "actualRecoveryTime": {
                return Optional.ofNullable(clazz.cast(this.actualRecoveryTime()));
            }
            case "generatedReportDetails": {
                return Optional.ofNullable(clazz.cast(this.generatedReportDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("executionState", EXECUTION_STATE_FIELD);
        map.put("executionAction", EXECUTION_ACTION_FIELD);
        map.put("executionRegion", EXECUTION_REGION_FIELD);
        map.put("stepStates", STEP_STATES_FIELD);
        map.put("plan", PLAN_FIELD);
        map.put("actualRecoveryTime", ACTUAL_RECOVERY_TIME_FIELD);
        map.put("generatedReportDetails", GENERATED_REPORT_DETAILS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPlanExecutionResponse, T> g) {
        return obj -> g.apply((GetPlanExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchResponse.BuilderImpl
    implements Builder {
        private String planArn;
        private String executionId;
        private String version;
        private Instant updatedAt;
        private String comment;
        private Instant startTime;
        private Instant endTime;
        private String mode;
        private String executionState;
        private String executionAction;
        private String executionRegion;
        private List<StepState> stepStates = DefaultSdkAutoConstructList.getInstance();
        private Plan plan;
        private String actualRecoveryTime;
        private List<GeneratedReport> generatedReportDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlanExecutionResponse model) {
            super(model);
            this.planArn(model.planArn);
            this.executionId(model.executionId);
            this.version(model.version);
            this.updatedAt(model.updatedAt);
            this.comment(model.comment);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.mode(model.mode);
            this.executionState(model.executionState);
            this.executionAction(model.executionAction);
            this.executionRegion(model.executionRegion);
            this.stepStates(model.stepStates);
            this.plan(model.plan);
            this.actualRecoveryTime(model.actualRecoveryTime);
            this.generatedReportDetails(model.generatedReportDetails);
            this.nextToken(model.nextToken);
        }

        public final String getPlanArn() {
            return this.planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getExecutionState() {
            return this.executionState;
        }

        public final void setExecutionState(String executionState) {
            this.executionState = executionState;
        }

        @Override
        public final Builder executionState(String executionState) {
            this.executionState = executionState;
            return this;
        }

        @Override
        public final Builder executionState(ExecutionState executionState) {
            this.executionState(executionState == null ? null : executionState.toString());
            return this;
        }

        public final String getExecutionAction() {
            return this.executionAction;
        }

        public final void setExecutionAction(String executionAction) {
            this.executionAction = executionAction;
        }

        @Override
        public final Builder executionAction(String executionAction) {
            this.executionAction = executionAction;
            return this;
        }

        @Override
        public final Builder executionAction(ExecutionAction executionAction) {
            this.executionAction(executionAction == null ? null : executionAction.toString());
            return this;
        }

        public final String getExecutionRegion() {
            return this.executionRegion;
        }

        public final void setExecutionRegion(String executionRegion) {
            this.executionRegion = executionRegion;
        }

        @Override
        public final Builder executionRegion(String executionRegion) {
            this.executionRegion = executionRegion;
            return this;
        }

        public final List<StepState.Builder> getStepStates() {
            List<StepState.Builder> result = StepStatesCopier.copyToBuilder(this.stepStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepStates(Collection<StepState.BuilderImpl> stepStates) {
            this.stepStates = StepStatesCopier.copyFromBuilder(stepStates);
        }

        @Override
        public final Builder stepStates(Collection<StepState> stepStates) {
            this.stepStates = StepStatesCopier.copy(stepStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStates(StepState ... stepStates) {
            this.stepStates(Arrays.asList(stepStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStates(Consumer<StepState.Builder> ... stepStates) {
            this.stepStates(Stream.of(stepStates).map(c -> (StepState)((StepState.Builder)StepState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Plan.Builder getPlan() {
            return this.plan != null ? this.plan.toBuilder() : null;
        }

        public final void setPlan(Plan.BuilderImpl plan) {
            this.plan = plan != null ? plan.build() : null;
        }

        @Override
        public final Builder plan(Plan plan) {
            this.plan = plan;
            return this;
        }

        public final String getActualRecoveryTime() {
            return this.actualRecoveryTime;
        }

        public final void setActualRecoveryTime(String actualRecoveryTime) {
            this.actualRecoveryTime = actualRecoveryTime;
        }

        @Override
        public final Builder actualRecoveryTime(String actualRecoveryTime) {
            this.actualRecoveryTime = actualRecoveryTime;
            return this;
        }

        public final List<GeneratedReport.Builder> getGeneratedReportDetails() {
            List<GeneratedReport.Builder> result = GeneratedReportDetailsCopier.copyToBuilder(this.generatedReportDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratedReportDetails(Collection<GeneratedReport.BuilderImpl> generatedReportDetails) {
            this.generatedReportDetails = GeneratedReportDetailsCopier.copyFromBuilder(generatedReportDetails);
        }

        @Override
        public final Builder generatedReportDetails(Collection<GeneratedReport> generatedReportDetails) {
            this.generatedReportDetails = GeneratedReportDetailsCopier.copy(generatedReportDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedReportDetails(GeneratedReport ... generatedReportDetails) {
            this.generatedReportDetails(Arrays.asList(generatedReportDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedReportDetails(Consumer<GeneratedReport.Builder> ... generatedReportDetails) {
            this.generatedReportDetails(Stream.of(generatedReportDetails).map(c -> (GeneratedReport)((GeneratedReport.Builder)GeneratedReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetPlanExecutionResponse build() {
            return new GetPlanExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPlanExecutionResponse> {
        public Builder planArn(String var1);

        public Builder executionId(String var1);

        public Builder version(String var1);

        public Builder updatedAt(Instant var1);

        public Builder comment(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder mode(String var1);

        public Builder mode(ExecutionMode var1);

        public Builder executionState(String var1);

        public Builder executionState(ExecutionState var1);

        public Builder executionAction(String var1);

        public Builder executionAction(ExecutionAction var1);

        public Builder executionRegion(String var1);

        public Builder stepStates(Collection<StepState> var1);

        public Builder stepStates(StepState ... var1);

        public Builder stepStates(Consumer<StepState.Builder> ... var1);

        public Builder plan(Plan var1);

        default public Builder plan(Consumer<Plan.Builder> plan) {
            return this.plan((Plan)((Plan.Builder)Plan.builder().applyMutation(plan)).build());
        }

        public Builder actualRecoveryTime(String var1);

        public Builder generatedReportDetails(Collection<GeneratedReport> var1);

        public Builder generatedReportDetails(GeneratedReport ... var1);

        public Builder generatedReportDetails(Consumer<GeneratedReport.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

