/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchResponse;
import software.amazon.awssdk.services.arcregionswitch.model.EvaluationStatus;
import software.amazon.awssdk.services.arcregionswitch.model.PlanWarningsCopier;
import software.amazon.awssdk.services.arcregionswitch.model.ResourceWarning;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPlanEvaluationStatusResponse
extends ArcRegionSwitchResponse
implements ToCopyableBuilder<Builder, GetPlanEvaluationStatusResponse> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planArn").getter(GetPlanEvaluationStatusResponse.getter(GetPlanEvaluationStatusResponse::planArn)).setter(GetPlanEvaluationStatusResponse.setter(Builder::planArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()}).build();
    private static final SdkField<Instant> LAST_EVALUATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastEvaluationTime").getter(GetPlanEvaluationStatusResponse.getter(GetPlanEvaluationStatusResponse::lastEvaluationTime)).setter(GetPlanEvaluationStatusResponse.setter(Builder::lastEvaluationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEvaluationTime").build()}).build();
    private static final SdkField<String> LAST_EVALUATED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastEvaluatedVersion").getter(GetPlanEvaluationStatusResponse.getter(GetPlanEvaluationStatusResponse::lastEvaluatedVersion)).setter(GetPlanEvaluationStatusResponse.setter(Builder::lastEvaluatedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEvaluatedVersion").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(GetPlanEvaluationStatusResponse.getter(GetPlanEvaluationStatusResponse::region)).setter(GetPlanEvaluationStatusResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> EVALUATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationState").getter(GetPlanEvaluationStatusResponse.getter(GetPlanEvaluationStatusResponse::evaluationStateAsString)).setter(GetPlanEvaluationStatusResponse.setter(Builder::evaluationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationState").build()}).build();
    private static final SdkField<List<ResourceWarning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("warnings").getter(GetPlanEvaluationStatusResponse.getter(GetPlanEvaluationStatusResponse::warnings)).setter(GetPlanEvaluationStatusResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetPlanEvaluationStatusResponse.getter(GetPlanEvaluationStatusResponse::nextToken)).setter(GetPlanEvaluationStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD, LAST_EVALUATION_TIME_FIELD, LAST_EVALUATED_VERSION_FIELD, REGION_FIELD, EVALUATION_STATE_FIELD, WARNINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPlanEvaluationStatusResponse.memberNameToFieldInitializer();
    private final String planArn;
    private final Instant lastEvaluationTime;
    private final String lastEvaluatedVersion;
    private final String region;
    private final String evaluationState;
    private final List<ResourceWarning> warnings;
    private final String nextToken;

    private GetPlanEvaluationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.lastEvaluationTime = builder.lastEvaluationTime;
        this.lastEvaluatedVersion = builder.lastEvaluatedVersion;
        this.region = builder.region;
        this.evaluationState = builder.evaluationState;
        this.warnings = builder.warnings;
        this.nextToken = builder.nextToken;
    }

    public final String planArn() {
        return this.planArn;
    }

    public final Instant lastEvaluationTime() {
        return this.lastEvaluationTime;
    }

    public final String lastEvaluatedVersion() {
        return this.lastEvaluatedVersion;
    }

    public final String region() {
        return this.region;
    }

    public final EvaluationStatus evaluationState() {
        return EvaluationStatus.fromValue(this.evaluationState);
    }

    public final String evaluationStateAsString() {
        return this.evaluationState;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<ResourceWarning> warnings() {
        return this.warnings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.planArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlanEvaluationStatusResponse)) {
            return false;
        }
        GetPlanEvaluationStatusResponse other = (GetPlanEvaluationStatusResponse)((Object)obj);
        return Objects.equals(this.planArn(), other.planArn()) && Objects.equals(this.lastEvaluationTime(), other.lastEvaluationTime()) && Objects.equals(this.lastEvaluatedVersion(), other.lastEvaluatedVersion()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.evaluationStateAsString(), other.evaluationStateAsString()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetPlanEvaluationStatusResponse").add("PlanArn", (Object)this.planArn()).add("LastEvaluationTime", (Object)this.lastEvaluationTime()).add("LastEvaluatedVersion", (Object)this.lastEvaluatedVersion()).add("Region", (Object)this.region()).add("EvaluationState", (Object)this.evaluationStateAsString()).add("Warnings", this.hasWarnings() ? this.warnings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "planArn": {
                return Optional.ofNullable(clazz.cast(this.planArn()));
            }
            case "lastEvaluationTime": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluationTime()));
            }
            case "lastEvaluatedVersion": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedVersion()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "evaluationState": {
                return Optional.ofNullable(clazz.cast(this.evaluationStateAsString()));
            }
            case "warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("lastEvaluationTime", LAST_EVALUATION_TIME_FIELD);
        map.put("lastEvaluatedVersion", LAST_EVALUATED_VERSION_FIELD);
        map.put("region", REGION_FIELD);
        map.put("evaluationState", EVALUATION_STATE_FIELD);
        map.put("warnings", WARNINGS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPlanEvaluationStatusResponse, T> g) {
        return obj -> g.apply((GetPlanEvaluationStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchResponse.BuilderImpl
    implements Builder {
        private String planArn;
        private Instant lastEvaluationTime;
        private String lastEvaluatedVersion;
        private String region;
        private String evaluationState;
        private List<ResourceWarning> warnings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlanEvaluationStatusResponse model) {
            super(model);
            this.planArn(model.planArn);
            this.lastEvaluationTime(model.lastEvaluationTime);
            this.lastEvaluatedVersion(model.lastEvaluatedVersion);
            this.region(model.region);
            this.evaluationState(model.evaluationState);
            this.warnings(model.warnings);
            this.nextToken(model.nextToken);
        }

        public final String getPlanArn() {
            return this.planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final Instant getLastEvaluationTime() {
            return this.lastEvaluationTime;
        }

        public final void setLastEvaluationTime(Instant lastEvaluationTime) {
            this.lastEvaluationTime = lastEvaluationTime;
        }

        @Override
        public final Builder lastEvaluationTime(Instant lastEvaluationTime) {
            this.lastEvaluationTime = lastEvaluationTime;
            return this;
        }

        public final String getLastEvaluatedVersion() {
            return this.lastEvaluatedVersion;
        }

        public final void setLastEvaluatedVersion(String lastEvaluatedVersion) {
            this.lastEvaluatedVersion = lastEvaluatedVersion;
        }

        @Override
        public final Builder lastEvaluatedVersion(String lastEvaluatedVersion) {
            this.lastEvaluatedVersion = lastEvaluatedVersion;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getEvaluationState() {
            return this.evaluationState;
        }

        public final void setEvaluationState(String evaluationState) {
            this.evaluationState = evaluationState;
        }

        @Override
        public final Builder evaluationState(String evaluationState) {
            this.evaluationState = evaluationState;
            return this;
        }

        @Override
        public final Builder evaluationState(EvaluationStatus evaluationState) {
            this.evaluationState(evaluationState == null ? null : evaluationState.toString());
            return this;
        }

        public final List<ResourceWarning.Builder> getWarnings() {
            List<ResourceWarning.Builder> result = PlanWarningsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<ResourceWarning.BuilderImpl> warnings) {
            this.warnings = PlanWarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<ResourceWarning> warnings) {
            this.warnings = PlanWarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(ResourceWarning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<ResourceWarning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (ResourceWarning)((ResourceWarning.Builder)ResourceWarning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetPlanEvaluationStatusResponse build() {
            return new GetPlanEvaluationStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPlanEvaluationStatusResponse> {
        public Builder planArn(String var1);

        public Builder lastEvaluationTime(Instant var1);

        public Builder lastEvaluatedVersion(String var1);

        public Builder region(String var1);

        public Builder evaluationState(String var1);

        public Builder evaluationState(EvaluationStatus var1);

        public Builder warnings(Collection<ResourceWarning> var1);

        public Builder warnings(ResourceWarning ... var1);

        public Builder warnings(Consumer<ResourceWarning.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

