/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionBlockType {
    CUSTOM_ACTION_LAMBDA("CustomActionLambda"),
    MANUAL_APPROVAL("ManualApproval"),
    AURORA_GLOBAL_DATABASE("AuroraGlobalDatabase"),
    EC2_AUTO_SCALING("EC2AutoScaling"),
    ARC_ROUTING_CONTROL("ARCRoutingControl"),
    ARC_REGION_SWITCH_PLAN("ARCRegionSwitchPlan"),
    PARALLEL("Parallel"),
    ECS_SERVICE_SCALING("ECSServiceScaling"),
    EKS_RESOURCE_SCALING("EKSResourceScaling"),
    ROUTE53_HEALTH_CHECK("Route53HealthCheck"),
    DOCUMENT_DB("DocumentDb"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionBlockType> VALUE_MAP;
    private final String value;

    private ExecutionBlockType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionBlockType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionBlockType> knownValues() {
        EnumSet<ExecutionBlockType> knownValues = EnumSet.allOf(ExecutionBlockType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionBlockType.class, ExecutionBlockType::toString);
    }
}

