/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for Amazon Aurora global databases used in a Region switch plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalAuroraConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalAuroraConfiguration.Builder, GlobalAuroraConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(GlobalAuroraConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("crossAccountRole").getter(getter(GlobalAuroraConfiguration::crossAccountRole))
            .setter(setter(Builder::crossAccountRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(GlobalAuroraConfiguration::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("behavior").getter(getter(GlobalAuroraConfiguration::behaviorAsString)).setter(setter(Builder::behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()).build();

    private static final SdkField<GlobalAuroraUngraceful> UNGRACEFUL_FIELD = SdkField
            .<GlobalAuroraUngraceful> builder(MarshallingType.SDK_POJO).memberName("ungraceful")
            .getter(getter(GlobalAuroraConfiguration::ungraceful)).setter(setter(Builder::ungraceful))
            .constructor(GlobalAuroraUngraceful::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()).build();

    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("globalClusterIdentifier").getter(getter(GlobalAuroraConfiguration::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalClusterIdentifier").build())
            .build();

    private static final SdkField<List<String>> DATABASE_CLUSTER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("databaseClusterArns")
            .getter(getter(GlobalAuroraConfiguration::databaseClusterArns))
            .setter(setter(Builder::databaseClusterArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseClusterArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD,
            CROSS_ACCOUNT_ROLE_FIELD, EXTERNAL_ID_FIELD, BEHAVIOR_FIELD, UNGRACEFUL_FIELD, GLOBAL_CLUSTER_IDENTIFIER_FIELD,
            DATABASE_CLUSTER_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutMinutes;

    private final String crossAccountRole;

    private final String externalId;

    private final String behavior;

    private final GlobalAuroraUngraceful ungraceful;

    private final String globalClusterIdentifier;

    private final List<String> databaseClusterArns;

    private GlobalAuroraConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.behavior = builder.behavior;
        this.ungraceful = builder.ungraceful;
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.databaseClusterArns = builder.databaseClusterArns;
    }

    /**
     * <p>
     * The timeout value specified for the configuration.
     * </p>
     * 
     * @return The timeout value specified for the configuration.
     */
    public final Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    /**
     * <p>
     * The cross account role for the configuration.
     * </p>
     * 
     * @return The cross account role for the configuration.
     */
    public final String crossAccountRole() {
        return crossAccountRole;
    }

    /**
     * <p>
     * The external ID (secret key) for the configuration.
     * </p>
     * 
     * @return The external ID (secret key) for the configuration.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The behavior for a global database, that is, only allow switchover or also allow failover.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link GlobalAuroraDefaultBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #behaviorAsString}.
     * </p>
     * 
     * @return The behavior for a global database, that is, only allow switchover or also allow failover.
     * @see GlobalAuroraDefaultBehavior
     */
    public final GlobalAuroraDefaultBehavior behavior() {
        return GlobalAuroraDefaultBehavior.fromValue(behavior);
    }

    /**
     * <p>
     * The behavior for a global database, that is, only allow switchover or also allow failover.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link GlobalAuroraDefaultBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #behaviorAsString}.
     * </p>
     * 
     * @return The behavior for a global database, that is, only allow switchover or also allow failover.
     * @see GlobalAuroraDefaultBehavior
     */
    public final String behaviorAsString() {
        return behavior;
    }

    /**
     * <p>
     * The settings for ungraceful execution.
     * </p>
     * 
     * @return The settings for ungraceful execution.
     */
    public final GlobalAuroraUngraceful ungraceful() {
        return ungraceful;
    }

    /**
     * <p>
     * The global cluster identifier for a global database.
     * </p>
     * 
     * @return The global cluster identifier for a global database.
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatabaseClusterArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatabaseClusterArns() {
        return databaseClusterArns != null && !(databaseClusterArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The database cluster Amazon Resource Names (ARNs) for a global database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatabaseClusterArns} method.
     * </p>
     * 
     * @return The database cluster Amazon Resource Names (ARNs) for a global database.
     */
    public final List<String> databaseClusterArns() {
        return databaseClusterArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ungraceful());
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasDatabaseClusterArns() ? databaseClusterArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalAuroraConfiguration)) {
            return false;
        }
        GlobalAuroraConfiguration other = (GlobalAuroraConfiguration) obj;
        return Objects.equals(timeoutMinutes(), other.timeoutMinutes())
                && Objects.equals(crossAccountRole(), other.crossAccountRole())
                && Objects.equals(externalId(), other.externalId())
                && Objects.equals(behaviorAsString(), other.behaviorAsString())
                && Objects.equals(ungraceful(), other.ungraceful())
                && Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && hasDatabaseClusterArns() == other.hasDatabaseClusterArns()
                && Objects.equals(databaseClusterArns(), other.databaseClusterArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalAuroraConfiguration").add("TimeoutMinutes", timeoutMinutes())
                .add("CrossAccountRole", crossAccountRole()).add("ExternalId", externalId()).add("Behavior", behaviorAsString())
                .add("Ungraceful", ungraceful()).add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("DatabaseClusterArns", hasDatabaseClusterArns() ? databaseClusterArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        case "crossAccountRole":
            return Optional.ofNullable(clazz.cast(crossAccountRole()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "behavior":
            return Optional.ofNullable(clazz.cast(behaviorAsString()));
        case "ungraceful":
            return Optional.ofNullable(clazz.cast(ungraceful()));
        case "globalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "databaseClusterArns":
            return Optional.ofNullable(clazz.cast(databaseClusterArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("behavior", BEHAVIOR_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        map.put("globalClusterIdentifier", GLOBAL_CLUSTER_IDENTIFIER_FIELD);
        map.put("databaseClusterArns", DATABASE_CLUSTER_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalAuroraConfiguration, T> g) {
        return obj -> g.apply((GlobalAuroraConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalAuroraConfiguration> {
        /**
         * <p>
         * The timeout value specified for the configuration.
         * </p>
         * 
         * @param timeoutMinutes
         *        The timeout value specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);

        /**
         * <p>
         * The cross account role for the configuration.
         * </p>
         * 
         * @param crossAccountRole
         *        The cross account role for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountRole(String crossAccountRole);

        /**
         * <p>
         * The external ID (secret key) for the configuration.
         * </p>
         * 
         * @param externalId
         *        The external ID (secret key) for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The behavior for a global database, that is, only allow switchover or also allow failover.
         * </p>
         * 
         * @param behavior
         *        The behavior for a global database, that is, only allow switchover or also allow failover.
         * @see GlobalAuroraDefaultBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalAuroraDefaultBehavior
         */
        Builder behavior(String behavior);

        /**
         * <p>
         * The behavior for a global database, that is, only allow switchover or also allow failover.
         * </p>
         * 
         * @param behavior
         *        The behavior for a global database, that is, only allow switchover or also allow failover.
         * @see GlobalAuroraDefaultBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalAuroraDefaultBehavior
         */
        Builder behavior(GlobalAuroraDefaultBehavior behavior);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * 
         * @param ungraceful
         *        The settings for ungraceful execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ungraceful(GlobalAuroraUngraceful ungraceful);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlobalAuroraUngraceful.Builder} avoiding
         * the need to create one manually via {@link GlobalAuroraUngraceful#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlobalAuroraUngraceful.Builder#build()} is called immediately and
         * its result is passed to {@link #ungraceful(GlobalAuroraUngraceful)}.
         * 
         * @param ungraceful
         *        a consumer that will call methods on {@link GlobalAuroraUngraceful.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ungraceful(GlobalAuroraUngraceful)
         */
        default Builder ungraceful(Consumer<GlobalAuroraUngraceful.Builder> ungraceful) {
            return ungraceful(GlobalAuroraUngraceful.builder().applyMutation(ungraceful).build());
        }

        /**
         * <p>
         * The global cluster identifier for a global database.
         * </p>
         * 
         * @param globalClusterIdentifier
         *        The global cluster identifier for a global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * The database cluster Amazon Resource Names (ARNs) for a global database.
         * </p>
         * 
         * @param databaseClusterArns
         *        The database cluster Amazon Resource Names (ARNs) for a global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseClusterArns(Collection<String> databaseClusterArns);

        /**
         * <p>
         * The database cluster Amazon Resource Names (ARNs) for a global database.
         * </p>
         * 
         * @param databaseClusterArns
         *        The database cluster Amazon Resource Names (ARNs) for a global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseClusterArns(String... databaseClusterArns);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutMinutes;

        private String crossAccountRole;

        private String externalId;

        private String behavior;

        private GlobalAuroraUngraceful ungraceful;

        private String globalClusterIdentifier;

        private List<String> databaseClusterArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalAuroraConfiguration model) {
            timeoutMinutes(model.timeoutMinutes);
            crossAccountRole(model.crossAccountRole);
            externalId(model.externalId);
            behavior(model.behavior);
            ungraceful(model.ungraceful);
            globalClusterIdentifier(model.globalClusterIdentifier);
            databaseClusterArns(model.databaseClusterArns);
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final String getCrossAccountRole() {
            return crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getBehavior() {
            return behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(GlobalAuroraDefaultBehavior behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final GlobalAuroraUngraceful.Builder getUngraceful() {
            return ungraceful != null ? ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(GlobalAuroraUngraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(GlobalAuroraUngraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final Collection<String> getDatabaseClusterArns() {
            if (databaseClusterArns instanceof SdkAutoConstructList) {
                return null;
            }
            return databaseClusterArns;
        }

        public final void setDatabaseClusterArns(Collection<String> databaseClusterArns) {
            this.databaseClusterArns = AuroraClusterArnsCopier.copy(databaseClusterArns);
        }

        @Override
        public final Builder databaseClusterArns(Collection<String> databaseClusterArns) {
            this.databaseClusterArns = AuroraClusterArnsCopier.copy(databaseClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseClusterArns(String... databaseClusterArns) {
            databaseClusterArns(Arrays.asList(databaseClusterArns));
            return this;
        }

        @Override
        public GlobalAuroraConfiguration build() {
            return new GlobalAuroraConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
