/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.Route53ResourceRecordSet;
import software.amazon.awssdk.services.arcregionswitch.model.Route53ResourceRecordSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Route53HealthCheckConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Route53HealthCheckConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutMinutes").getter(Route53HealthCheckConfiguration.getter(Route53HealthCheckConfiguration::timeoutMinutes)).setter(Route53HealthCheckConfiguration.setter(Builder::timeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()}).build();
    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("crossAccountRole").getter(Route53HealthCheckConfiguration.getter(Route53HealthCheckConfiguration::crossAccountRole)).setter(Route53HealthCheckConfiguration.setter(Builder::crossAccountRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(Route53HealthCheckConfiguration.getter(Route53HealthCheckConfiguration::externalId)).setter(Route53HealthCheckConfiguration.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostedZoneId").getter(Route53HealthCheckConfiguration.getter(Route53HealthCheckConfiguration::hostedZoneId)).setter(Route53HealthCheckConfiguration.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()}).build();
    private static final SdkField<String> RECORD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordName").getter(Route53HealthCheckConfiguration.getter(Route53HealthCheckConfiguration::recordName)).setter(Route53HealthCheckConfiguration.setter(Builder::recordName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordName").build()}).build();
    private static final SdkField<List<Route53ResourceRecordSet>> RECORD_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recordSets").getter(Route53HealthCheckConfiguration.getter(Route53HealthCheckConfiguration::recordSets)).setter(Route53HealthCheckConfiguration.setter(Builder::recordSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route53ResourceRecordSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD, CROSS_ACCOUNT_ROLE_FIELD, EXTERNAL_ID_FIELD, HOSTED_ZONE_ID_FIELD, RECORD_NAME_FIELD, RECORD_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Route53HealthCheckConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer timeoutMinutes;
    private final String crossAccountRole;
    private final String externalId;
    private final String hostedZoneId;
    private final String recordName;
    private final List<Route53ResourceRecordSet> recordSets;

    private Route53HealthCheckConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.hostedZoneId = builder.hostedZoneId;
        this.recordName = builder.recordName;
        this.recordSets = builder.recordSets;
    }

    public final Integer timeoutMinutes() {
        return this.timeoutMinutes;
    }

    public final String crossAccountRole() {
        return this.crossAccountRole;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final String recordName() {
        return this.recordName;
    }

    public final boolean hasRecordSets() {
        return this.recordSets != null && !(this.recordSets instanceof SdkAutoConstructList);
    }

    public final List<Route53ResourceRecordSet> recordSets() {
        return this.recordSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordSets() ? this.recordSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route53HealthCheckConfiguration)) {
            return false;
        }
        Route53HealthCheckConfiguration other = (Route53HealthCheckConfiguration)obj;
        return Objects.equals(this.timeoutMinutes(), other.timeoutMinutes()) && Objects.equals(this.crossAccountRole(), other.crossAccountRole()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.recordName(), other.recordName()) && this.hasRecordSets() == other.hasRecordSets() && Objects.equals(this.recordSets(), other.recordSets());
    }

    public final String toString() {
        return ToString.builder((String)"Route53HealthCheckConfiguration").add("TimeoutMinutes", (Object)this.timeoutMinutes()).add("CrossAccountRole", (Object)this.crossAccountRole()).add("ExternalId", (Object)this.externalId()).add("HostedZoneId", (Object)this.hostedZoneId()).add("RecordName", (Object)this.recordName()).add("RecordSets", this.hasRecordSets() ? this.recordSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutMinutes()));
            }
            case "crossAccountRole": {
                return Optional.ofNullable(clazz.cast(this.crossAccountRole()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "hostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "recordName": {
                return Optional.ofNullable(clazz.cast(this.recordName()));
            }
            case "recordSets": {
                return Optional.ofNullable(clazz.cast(this.recordSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("hostedZoneId", HOSTED_ZONE_ID_FIELD);
        map.put("recordName", RECORD_NAME_FIELD);
        map.put("recordSets", RECORD_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route53HealthCheckConfiguration, T> g) {
        return obj -> g.apply((Route53HealthCheckConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutMinutes;
        private String crossAccountRole;
        private String externalId;
        private String hostedZoneId;
        private String recordName;
        private List<Route53ResourceRecordSet> recordSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Route53HealthCheckConfiguration model) {
            this.timeoutMinutes(model.timeoutMinutes);
            this.crossAccountRole(model.crossAccountRole);
            this.externalId(model.externalId);
            this.hostedZoneId(model.hostedZoneId);
            this.recordName(model.recordName);
            this.recordSets(model.recordSets);
        }

        public final Integer getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final String getCrossAccountRole() {
            return this.crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getRecordName() {
            return this.recordName;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final List<Route53ResourceRecordSet.Builder> getRecordSets() {
            List<Route53ResourceRecordSet.Builder> result = Route53ResourceRecordSetListCopier.copyToBuilder(this.recordSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordSets(Collection<Route53ResourceRecordSet.BuilderImpl> recordSets) {
            this.recordSets = Route53ResourceRecordSetListCopier.copyFromBuilder(recordSets);
        }

        @Override
        public final Builder recordSets(Collection<Route53ResourceRecordSet> recordSets) {
            this.recordSets = Route53ResourceRecordSetListCopier.copy(recordSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordSets(Route53ResourceRecordSet ... recordSets) {
            this.recordSets(Arrays.asList(recordSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordSets(Consumer<Route53ResourceRecordSet.Builder> ... recordSets) {
            this.recordSets(Stream.of(recordSets).map(c -> (Route53ResourceRecordSet)((Route53ResourceRecordSet.Builder)Route53ResourceRecordSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Route53HealthCheckConfiguration build() {
            return new Route53HealthCheckConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Route53HealthCheckConfiguration> {
        public Builder timeoutMinutes(Integer var1);

        public Builder crossAccountRole(String var1);

        public Builder externalId(String var1);

        public Builder hostedZoneId(String var1);

        public Builder recordName(String var1);

        public Builder recordSets(Collection<Route53ResourceRecordSet> var1);

        public Builder recordSets(Route53ResourceRecordSet ... var1);

        public Builder recordSets(Consumer<Route53ResourceRecordSet.Builder> ... var1);
    }
}

