/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchAsyncClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.AbbreviatedPlan;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlansInRegionResponse;

public class ListPlansInRegionPublisher
implements SdkPublisher<ListPlansInRegionResponse> {
    private final ArcRegionSwitchAsyncClient client;
    private final ListPlansInRegionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlansInRegionPublisher(ArcRegionSwitchAsyncClient client, ListPlansInRegionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlansInRegionPublisher(ArcRegionSwitchAsyncClient client, ListPlansInRegionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlansInRegionResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlansInRegionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AbbreviatedPlan> plans() {
        Function<ListPlansInRegionResponse, Iterator> getIterator = response -> {
            if (response != null && response.plans() != null) {
                return response.plans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPlansInRegionResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPlansInRegionResponseFetcher
    implements AsyncPageFetcher<ListPlansInRegionResponse> {
        private ListPlansInRegionResponseFetcher() {
        }

        public boolean hasNextPage(ListPlansInRegionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlansInRegionResponse> nextPage(ListPlansInRegionResponse previousPage) {
            if (previousPage == null) {
                return ListPlansInRegionPublisher.this.client.listPlansInRegion(ListPlansInRegionPublisher.this.firstRequest);
            }
            return ListPlansInRegionPublisher.this.client.listPlansInRegion((ListPlansInRegionRequest)((Object)ListPlansInRegionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

