/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchAsyncClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.AbbreviatedExecution;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionsResponse;

public class ListPlanExecutionsPublisher
implements SdkPublisher<ListPlanExecutionsResponse> {
    private final ArcRegionSwitchAsyncClient client;
    private final ListPlanExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlanExecutionsPublisher(ArcRegionSwitchAsyncClient client, ListPlanExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlanExecutionsPublisher(ArcRegionSwitchAsyncClient client, ListPlanExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlanExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlanExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AbbreviatedExecution> items() {
        Function<ListPlanExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPlanExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPlanExecutionsResponseFetcher
    implements AsyncPageFetcher<ListPlanExecutionsResponse> {
        private ListPlanExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlanExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlanExecutionsResponse> nextPage(ListPlanExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListPlanExecutionsPublisher.this.client.listPlanExecutions(ListPlanExecutionsPublisher.this.firstRequest);
            }
            return ListPlanExecutionsPublisher.this.client.listPlanExecutions((ListPlanExecutionsRequest)((Object)ListPlanExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

