/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchAsyncClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksResponse;
import software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheck;

public class ListRoute53HealthChecksPublisher
implements SdkPublisher<ListRoute53HealthChecksResponse> {
    private final ArcRegionSwitchAsyncClient client;
    private final ListRoute53HealthChecksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoute53HealthChecksPublisher(ArcRegionSwitchAsyncClient client, ListRoute53HealthChecksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoute53HealthChecksPublisher(ArcRegionSwitchAsyncClient client, ListRoute53HealthChecksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoute53HealthChecksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoute53HealthChecksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Route53HealthCheck> healthChecks() {
        Function<ListRoute53HealthChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.healthChecks() != null) {
                return response.healthChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoute53HealthChecksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoute53HealthChecksResponseFetcher
    implements AsyncPageFetcher<ListRoute53HealthChecksResponse> {
        private ListRoute53HealthChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListRoute53HealthChecksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRoute53HealthChecksResponse> nextPage(ListRoute53HealthChecksResponse previousPage) {
            if (previousPage == null) {
                return ListRoute53HealthChecksPublisher.this.client.listRoute53HealthChecks(ListRoute53HealthChecksPublisher.this.firstRequest);
            }
            return ListRoute53HealthChecksPublisher.this.client.listRoute53HealthChecks((ListRoute53HealthChecksRequest)((Object)ListRoute53HealthChecksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

