/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.EksCapacityMonitoringApproach;
import software.amazon.awssdk.services.arcregionswitch.model.EksCluster;
import software.amazon.awssdk.services.arcregionswitch.model.EksClustersCopier;
import software.amazon.awssdk.services.arcregionswitch.model.EksResourceScalingUngraceful;
import software.amazon.awssdk.services.arcregionswitch.model.KubernetesResourceType;
import software.amazon.awssdk.services.arcregionswitch.model.KubernetesScalingAppsCopier;
import software.amazon.awssdk.services.arcregionswitch.model.KubernetesScalingResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksResourceScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksResourceScalingConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutMinutes").getter(EksResourceScalingConfiguration.getter(EksResourceScalingConfiguration::timeoutMinutes)).setter(EksResourceScalingConfiguration.setter(Builder::timeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()}).build();
    private static final SdkField<KubernetesResourceType> KUBERNETES_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kubernetesResourceType").getter(EksResourceScalingConfiguration.getter(EksResourceScalingConfiguration::kubernetesResourceType)).setter(EksResourceScalingConfiguration.setter(Builder::kubernetesResourceType)).constructor(KubernetesResourceType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesResourceType").build()}).build();
    private static final SdkField<List<Map<String, Map<String, KubernetesScalingResource>>>> SCALING_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scalingResources").getter(EksResourceScalingConfiguration.getter(EksResourceScalingConfiguration::scalingResources)).setter(EksResourceScalingConfiguration.setter(Builder::scalingResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KubernetesScalingResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<EksCluster>> EKS_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eksClusters").getter(EksResourceScalingConfiguration.getter(EksResourceScalingConfiguration::eksClusters)).setter(EksResourceScalingConfiguration.setter(Builder::eksClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EksResourceScalingUngraceful> UNGRACEFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ungraceful").getter(EksResourceScalingConfiguration.getter(EksResourceScalingConfiguration::ungraceful)).setter(EksResourceScalingConfiguration.setter(Builder::ungraceful)).constructor(EksResourceScalingUngraceful::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()}).build();
    private static final SdkField<Integer> TARGET_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("targetPercent").getter(EksResourceScalingConfiguration.getter(EksResourceScalingConfiguration::targetPercent)).setter(EksResourceScalingConfiguration.setter(Builder::targetPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPercent").build()}).build();
    private static final SdkField<String> CAPACITY_MONITORING_APPROACH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capacityMonitoringApproach").getter(EksResourceScalingConfiguration.getter(EksResourceScalingConfiguration::capacityMonitoringApproachAsString)).setter(EksResourceScalingConfiguration.setter(Builder::capacityMonitoringApproach)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityMonitoringApproach").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD, KUBERNETES_RESOURCE_TYPE_FIELD, SCALING_RESOURCES_FIELD, EKS_CLUSTERS_FIELD, UNGRACEFUL_FIELD, TARGET_PERCENT_FIELD, CAPACITY_MONITORING_APPROACH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EksResourceScalingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer timeoutMinutes;
    private final KubernetesResourceType kubernetesResourceType;
    private final List<Map<String, Map<String, KubernetesScalingResource>>> scalingResources;
    private final List<EksCluster> eksClusters;
    private final EksResourceScalingUngraceful ungraceful;
    private final Integer targetPercent;
    private final String capacityMonitoringApproach;

    private EksResourceScalingConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.kubernetesResourceType = builder.kubernetesResourceType;
        this.scalingResources = builder.scalingResources;
        this.eksClusters = builder.eksClusters;
        this.ungraceful = builder.ungraceful;
        this.targetPercent = builder.targetPercent;
        this.capacityMonitoringApproach = builder.capacityMonitoringApproach;
    }

    public final Integer timeoutMinutes() {
        return this.timeoutMinutes;
    }

    public final KubernetesResourceType kubernetesResourceType() {
        return this.kubernetesResourceType;
    }

    public final boolean hasScalingResources() {
        return this.scalingResources != null && !(this.scalingResources instanceof SdkAutoConstructList);
    }

    public final List<Map<String, Map<String, KubernetesScalingResource>>> scalingResources() {
        return this.scalingResources;
    }

    public final boolean hasEksClusters() {
        return this.eksClusters != null && !(this.eksClusters instanceof SdkAutoConstructList);
    }

    public final List<EksCluster> eksClusters() {
        return this.eksClusters;
    }

    public final EksResourceScalingUngraceful ungraceful() {
        return this.ungraceful;
    }

    public final Integer targetPercent() {
        return this.targetPercent;
    }

    public final EksCapacityMonitoringApproach capacityMonitoringApproach() {
        return EksCapacityMonitoringApproach.fromValue(this.capacityMonitoringApproach);
    }

    public final String capacityMonitoringApproachAsString() {
        return this.capacityMonitoringApproach;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingResources() ? this.scalingResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEksClusters() ? this.eksClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ungraceful());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityMonitoringApproachAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksResourceScalingConfiguration)) {
            return false;
        }
        EksResourceScalingConfiguration other = (EksResourceScalingConfiguration)obj;
        return Objects.equals(this.timeoutMinutes(), other.timeoutMinutes()) && Objects.equals(this.kubernetesResourceType(), other.kubernetesResourceType()) && this.hasScalingResources() == other.hasScalingResources() && Objects.equals(this.scalingResources(), other.scalingResources()) && this.hasEksClusters() == other.hasEksClusters() && Objects.equals(this.eksClusters(), other.eksClusters()) && Objects.equals(this.ungraceful(), other.ungraceful()) && Objects.equals(this.targetPercent(), other.targetPercent()) && Objects.equals(this.capacityMonitoringApproachAsString(), other.capacityMonitoringApproachAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EksResourceScalingConfiguration").add("TimeoutMinutes", (Object)this.timeoutMinutes()).add("KubernetesResourceType", (Object)this.kubernetesResourceType()).add("ScalingResources", this.hasScalingResources() ? this.scalingResources() : null).add("EksClusters", this.hasEksClusters() ? this.eksClusters() : null).add("Ungraceful", (Object)this.ungraceful()).add("TargetPercent", (Object)this.targetPercent()).add("CapacityMonitoringApproach", (Object)this.capacityMonitoringApproachAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutMinutes()));
            }
            case "kubernetesResourceType": {
                return Optional.ofNullable(clazz.cast(this.kubernetesResourceType()));
            }
            case "scalingResources": {
                return Optional.ofNullable(clazz.cast(this.scalingResources()));
            }
            case "eksClusters": {
                return Optional.ofNullable(clazz.cast(this.eksClusters()));
            }
            case "ungraceful": {
                return Optional.ofNullable(clazz.cast(this.ungraceful()));
            }
            case "targetPercent": {
                return Optional.ofNullable(clazz.cast(this.targetPercent()));
            }
            case "capacityMonitoringApproach": {
                return Optional.ofNullable(clazz.cast(this.capacityMonitoringApproachAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("kubernetesResourceType", KUBERNETES_RESOURCE_TYPE_FIELD);
        map.put("scalingResources", SCALING_RESOURCES_FIELD);
        map.put("eksClusters", EKS_CLUSTERS_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        map.put("targetPercent", TARGET_PERCENT_FIELD);
        map.put("capacityMonitoringApproach", CAPACITY_MONITORING_APPROACH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksResourceScalingConfiguration, T> g) {
        return obj -> g.apply((EksResourceScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutMinutes;
        private KubernetesResourceType kubernetesResourceType;
        private List<Map<String, Map<String, KubernetesScalingResource>>> scalingResources = DefaultSdkAutoConstructList.getInstance();
        private List<EksCluster> eksClusters = DefaultSdkAutoConstructList.getInstance();
        private EksResourceScalingUngraceful ungraceful;
        private Integer targetPercent;
        private String capacityMonitoringApproach;

        private BuilderImpl() {
        }

        private BuilderImpl(EksResourceScalingConfiguration model) {
            this.timeoutMinutes(model.timeoutMinutes);
            this.kubernetesResourceType(model.kubernetesResourceType);
            this.scalingResources(model.scalingResources);
            this.eksClusters(model.eksClusters);
            this.ungraceful(model.ungraceful);
            this.targetPercent(model.targetPercent);
            this.capacityMonitoringApproach(model.capacityMonitoringApproach);
        }

        public final Integer getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final KubernetesResourceType.Builder getKubernetesResourceType() {
            return this.kubernetesResourceType != null ? this.kubernetesResourceType.toBuilder() : null;
        }

        public final void setKubernetesResourceType(KubernetesResourceType.BuilderImpl kubernetesResourceType) {
            this.kubernetesResourceType = kubernetesResourceType != null ? kubernetesResourceType.build() : null;
        }

        @Override
        public final Builder kubernetesResourceType(KubernetesResourceType kubernetesResourceType) {
            this.kubernetesResourceType = kubernetesResourceType;
            return this;
        }

        public final List<Map<String, Map<String, KubernetesScalingResource.Builder>>> getScalingResources() {
            List<Map<String, Map<String, KubernetesScalingResource.Builder>>> result = KubernetesScalingAppsCopier.copyToBuilder(this.scalingResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingResources(Collection<? extends Map<String, ? extends Map<String, KubernetesScalingResource.BuilderImpl>>> scalingResources) {
            this.scalingResources = KubernetesScalingAppsCopier.copyFromBuilder(scalingResources);
        }

        @Override
        public final Builder scalingResources(Collection<? extends Map<String, ? extends Map<String, KubernetesScalingResource>>> scalingResources) {
            this.scalingResources = KubernetesScalingAppsCopier.copy(scalingResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingResources(Map<String, ? extends Map<String, KubernetesScalingResource>> ... scalingResources) {
            this.scalingResources(Arrays.asList(scalingResources));
            return this;
        }

        public final List<EksCluster.Builder> getEksClusters() {
            List<EksCluster.Builder> result = EksClustersCopier.copyToBuilder(this.eksClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEksClusters(Collection<EksCluster.BuilderImpl> eksClusters) {
            this.eksClusters = EksClustersCopier.copyFromBuilder(eksClusters);
        }

        @Override
        public final Builder eksClusters(Collection<EksCluster> eksClusters) {
            this.eksClusters = EksClustersCopier.copy(eksClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksClusters(EksCluster ... eksClusters) {
            this.eksClusters(Arrays.asList(eksClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksClusters(Consumer<EksCluster.Builder> ... eksClusters) {
            this.eksClusters(Stream.of(eksClusters).map(c -> (EksCluster)((EksCluster.Builder)EksCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EksResourceScalingUngraceful.Builder getUngraceful() {
            return this.ungraceful != null ? this.ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(EksResourceScalingUngraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(EksResourceScalingUngraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        public final Integer getTargetPercent() {
            return this.targetPercent;
        }

        public final void setTargetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
        }

        @Override
        public final Builder targetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
            return this;
        }

        public final String getCapacityMonitoringApproach() {
            return this.capacityMonitoringApproach;
        }

        public final void setCapacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
        }

        @Override
        public final Builder capacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
            return this;
        }

        @Override
        public final Builder capacityMonitoringApproach(EksCapacityMonitoringApproach capacityMonitoringApproach) {
            this.capacityMonitoringApproach(capacityMonitoringApproach == null ? null : capacityMonitoringApproach.toString());
            return this;
        }

        public EksResourceScalingConfiguration build() {
            return new EksResourceScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksResourceScalingConfiguration> {
        public Builder timeoutMinutes(Integer var1);

        public Builder kubernetesResourceType(KubernetesResourceType var1);

        default public Builder kubernetesResourceType(Consumer<KubernetesResourceType.Builder> kubernetesResourceType) {
            return this.kubernetesResourceType((KubernetesResourceType)((KubernetesResourceType.Builder)KubernetesResourceType.builder().applyMutation(kubernetesResourceType)).build());
        }

        public Builder scalingResources(Collection<? extends Map<String, ? extends Map<String, KubernetesScalingResource>>> var1);

        public Builder scalingResources(Map<String, ? extends Map<String, KubernetesScalingResource>> ... var1);

        public Builder eksClusters(Collection<EksCluster> var1);

        public Builder eksClusters(EksCluster ... var1);

        public Builder eksClusters(Consumer<EksCluster.Builder> ... var1);

        public Builder ungraceful(EksResourceScalingUngraceful var1);

        default public Builder ungraceful(Consumer<EksResourceScalingUngraceful.Builder> ungraceful) {
            return this.ungraceful((EksResourceScalingUngraceful)((EksResourceScalingUngraceful.Builder)EksResourceScalingUngraceful.builder().applyMutation(ungraceful)).build());
        }

        public Builder targetPercent(Integer var1);

        public Builder capacityMonitoringApproach(String var1);

        public Builder capacityMonitoringApproach(EksCapacityMonitoringApproach var1);
    }
}

