/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.AuroraClusterArnsCopier;
import software.amazon.awssdk.services.arcregionswitch.model.GlobalAuroraDefaultBehavior;
import software.amazon.awssdk.services.arcregionswitch.model.GlobalAuroraUngraceful;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalAuroraConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalAuroraConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutMinutes").getter(GlobalAuroraConfiguration.getter(GlobalAuroraConfiguration::timeoutMinutes)).setter(GlobalAuroraConfiguration.setter(Builder::timeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()}).build();
    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("crossAccountRole").getter(GlobalAuroraConfiguration.getter(GlobalAuroraConfiguration::crossAccountRole)).setter(GlobalAuroraConfiguration.setter(Builder::crossAccountRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(GlobalAuroraConfiguration.getter(GlobalAuroraConfiguration::externalId)).setter(GlobalAuroraConfiguration.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("behavior").getter(GlobalAuroraConfiguration.getter(GlobalAuroraConfiguration::behaviorAsString)).setter(GlobalAuroraConfiguration.setter(Builder::behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()}).build();
    private static final SdkField<GlobalAuroraUngraceful> UNGRACEFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ungraceful").getter(GlobalAuroraConfiguration.getter(GlobalAuroraConfiguration::ungraceful)).setter(GlobalAuroraConfiguration.setter(Builder::ungraceful)).constructor(GlobalAuroraUngraceful::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()}).build();
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("globalClusterIdentifier").getter(GlobalAuroraConfiguration.getter(GlobalAuroraConfiguration::globalClusterIdentifier)).setter(GlobalAuroraConfiguration.setter(Builder::globalClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalClusterIdentifier").build()}).build();
    private static final SdkField<List<String>> DATABASE_CLUSTER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("databaseClusterArns").getter(GlobalAuroraConfiguration.getter(GlobalAuroraConfiguration::databaseClusterArns)).setter(GlobalAuroraConfiguration.setter(Builder::databaseClusterArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseClusterArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD, CROSS_ACCOUNT_ROLE_FIELD, EXTERNAL_ID_FIELD, BEHAVIOR_FIELD, UNGRACEFUL_FIELD, GLOBAL_CLUSTER_IDENTIFIER_FIELD, DATABASE_CLUSTER_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlobalAuroraConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer timeoutMinutes;
    private final String crossAccountRole;
    private final String externalId;
    private final String behavior;
    private final GlobalAuroraUngraceful ungraceful;
    private final String globalClusterIdentifier;
    private final List<String> databaseClusterArns;

    private GlobalAuroraConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.behavior = builder.behavior;
        this.ungraceful = builder.ungraceful;
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.databaseClusterArns = builder.databaseClusterArns;
    }

    public final Integer timeoutMinutes() {
        return this.timeoutMinutes;
    }

    public final String crossAccountRole() {
        return this.crossAccountRole;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final GlobalAuroraDefaultBehavior behavior() {
        return GlobalAuroraDefaultBehavior.fromValue(this.behavior);
    }

    public final String behaviorAsString() {
        return this.behavior;
    }

    public final GlobalAuroraUngraceful ungraceful() {
        return this.ungraceful;
    }

    public final String globalClusterIdentifier() {
        return this.globalClusterIdentifier;
    }

    public final boolean hasDatabaseClusterArns() {
        return this.databaseClusterArns != null && !(this.databaseClusterArns instanceof SdkAutoConstructList);
    }

    public final List<String> databaseClusterArns() {
        return this.databaseClusterArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ungraceful());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabaseClusterArns() ? this.databaseClusterArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalAuroraConfiguration)) {
            return false;
        }
        GlobalAuroraConfiguration other = (GlobalAuroraConfiguration)obj;
        return Objects.equals(this.timeoutMinutes(), other.timeoutMinutes()) && Objects.equals(this.crossAccountRole(), other.crossAccountRole()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.behaviorAsString(), other.behaviorAsString()) && Objects.equals(this.ungraceful(), other.ungraceful()) && Objects.equals(this.globalClusterIdentifier(), other.globalClusterIdentifier()) && this.hasDatabaseClusterArns() == other.hasDatabaseClusterArns() && Objects.equals(this.databaseClusterArns(), other.databaseClusterArns());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalAuroraConfiguration").add("TimeoutMinutes", (Object)this.timeoutMinutes()).add("CrossAccountRole", (Object)this.crossAccountRole()).add("ExternalId", (Object)this.externalId()).add("Behavior", (Object)this.behaviorAsString()).add("Ungraceful", (Object)this.ungraceful()).add("GlobalClusterIdentifier", (Object)this.globalClusterIdentifier()).add("DatabaseClusterArns", this.hasDatabaseClusterArns() ? this.databaseClusterArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutMinutes()));
            }
            case "crossAccountRole": {
                return Optional.ofNullable(clazz.cast(this.crossAccountRole()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "behavior": {
                return Optional.ofNullable(clazz.cast(this.behaviorAsString()));
            }
            case "ungraceful": {
                return Optional.ofNullable(clazz.cast(this.ungraceful()));
            }
            case "globalClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.globalClusterIdentifier()));
            }
            case "databaseClusterArns": {
                return Optional.ofNullable(clazz.cast(this.databaseClusterArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("behavior", BEHAVIOR_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        map.put("globalClusterIdentifier", GLOBAL_CLUSTER_IDENTIFIER_FIELD);
        map.put("databaseClusterArns", DATABASE_CLUSTER_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalAuroraConfiguration, T> g) {
        return obj -> g.apply((GlobalAuroraConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutMinutes;
        private String crossAccountRole;
        private String externalId;
        private String behavior;
        private GlobalAuroraUngraceful ungraceful;
        private String globalClusterIdentifier;
        private List<String> databaseClusterArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalAuroraConfiguration model) {
            this.timeoutMinutes(model.timeoutMinutes);
            this.crossAccountRole(model.crossAccountRole);
            this.externalId(model.externalId);
            this.behavior(model.behavior);
            this.ungraceful(model.ungraceful);
            this.globalClusterIdentifier(model.globalClusterIdentifier);
            this.databaseClusterArns(model.databaseClusterArns);
        }

        public final Integer getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final String getCrossAccountRole() {
            return this.crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getBehavior() {
            return this.behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(GlobalAuroraDefaultBehavior behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final GlobalAuroraUngraceful.Builder getUngraceful() {
            return this.ungraceful != null ? this.ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(GlobalAuroraUngraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(GlobalAuroraUngraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        public final String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final Collection<String> getDatabaseClusterArns() {
            if (this.databaseClusterArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.databaseClusterArns;
        }

        public final void setDatabaseClusterArns(Collection<String> databaseClusterArns) {
            this.databaseClusterArns = AuroraClusterArnsCopier.copy(databaseClusterArns);
        }

        @Override
        public final Builder databaseClusterArns(Collection<String> databaseClusterArns) {
            this.databaseClusterArns = AuroraClusterArnsCopier.copy(databaseClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseClusterArns(String ... databaseClusterArns) {
            this.databaseClusterArns(Arrays.asList(databaseClusterArns));
            return this;
        }

        public GlobalAuroraConfiguration build() {
            return new GlobalAuroraConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalAuroraConfiguration> {
        public Builder timeoutMinutes(Integer var1);

        public Builder crossAccountRole(String var1);

        public Builder externalId(String var1);

        public Builder behavior(String var1);

        public Builder behavior(GlobalAuroraDefaultBehavior var1);

        public Builder ungraceful(GlobalAuroraUngraceful var1);

        default public Builder ungraceful(Consumer<GlobalAuroraUngraceful.Builder> ungraceful) {
            return this.ungraceful((GlobalAuroraUngraceful)((GlobalAuroraUngraceful.Builder)GlobalAuroraUngraceful.builder().applyMutation(ungraceful)).build());
        }

        public Builder globalClusterIdentifier(String var1);

        public Builder databaseClusterArns(Collection<String> var1);

        public Builder databaseClusterArns(String ... var1);
    }
}

