/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Route 53 health check configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Route53HealthCheckConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<Route53HealthCheckConfiguration.Builder, Route53HealthCheckConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(Route53HealthCheckConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("crossAccountRole").getter(getter(Route53HealthCheckConfiguration::crossAccountRole))
            .setter(setter(Builder::crossAccountRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(Route53HealthCheckConfiguration::externalId))
            .setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostedZoneId").getter(getter(Route53HealthCheckConfiguration::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()).build();

    private static final SdkField<String> RECORD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordName").getter(getter(Route53HealthCheckConfiguration::recordName))
            .setter(setter(Builder::recordName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordName").build()).build();

    private static final SdkField<List<Route53ResourceRecordSet>> RECORD_SETS_FIELD = SdkField
            .<List<Route53ResourceRecordSet>> builder(MarshallingType.LIST)
            .memberName("recordSets")
            .getter(getter(Route53HealthCheckConfiguration::recordSets))
            .setter(setter(Builder::recordSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route53ResourceRecordSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route53ResourceRecordSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD,
            CROSS_ACCOUNT_ROLE_FIELD, EXTERNAL_ID_FIELD, HOSTED_ZONE_ID_FIELD, RECORD_NAME_FIELD, RECORD_SETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutMinutes;

    private final String crossAccountRole;

    private final String externalId;

    private final String hostedZoneId;

    private final String recordName;

    private final List<Route53ResourceRecordSet> recordSets;

    private Route53HealthCheckConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.hostedZoneId = builder.hostedZoneId;
        this.recordName = builder.recordName;
        this.recordSets = builder.recordSets;
    }

    /**
     * <p>
     * The Amazon Route 53 health check configuration time out (in minutes).
     * </p>
     * 
     * @return The Amazon Route 53 health check configuration time out (in minutes).
     */
    public final Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    /**
     * <p>
     * The cross account role for the configuration.
     * </p>
     * 
     * @return The cross account role for the configuration.
     */
    public final String crossAccountRole() {
        return crossAccountRole;
    }

    /**
     * <p>
     * The external ID (secret key) for the configuration.
     * </p>
     * 
     * @return The external ID (secret key) for the configuration.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The Amazon Route 53 health check configuration hosted zone ID.
     * </p>
     * 
     * @return The Amazon Route 53 health check configuration hosted zone ID.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The Amazon Route 53 health check configuration record name.
     * </p>
     * 
     * @return The Amazon Route 53 health check configuration record name.
     */
    public final String recordName() {
        return recordName;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecordSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecordSets() {
        return recordSets != null && !(recordSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Route 53 health check configuration record sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordSets} method.
     * </p>
     * 
     * @return The Amazon Route 53 health check configuration record sets.
     */
    public final List<Route53ResourceRecordSet> recordSets() {
        return recordSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(recordName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordSets() ? recordSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route53HealthCheckConfiguration)) {
            return false;
        }
        Route53HealthCheckConfiguration other = (Route53HealthCheckConfiguration) obj;
        return Objects.equals(timeoutMinutes(), other.timeoutMinutes())
                && Objects.equals(crossAccountRole(), other.crossAccountRole())
                && Objects.equals(externalId(), other.externalId()) && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(recordName(), other.recordName()) && hasRecordSets() == other.hasRecordSets()
                && Objects.equals(recordSets(), other.recordSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Route53HealthCheckConfiguration").add("TimeoutMinutes", timeoutMinutes())
                .add("CrossAccountRole", crossAccountRole()).add("ExternalId", externalId()).add("HostedZoneId", hostedZoneId())
                .add("RecordName", recordName()).add("RecordSets", hasRecordSets() ? recordSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        case "crossAccountRole":
            return Optional.ofNullable(clazz.cast(crossAccountRole()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "hostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "recordName":
            return Optional.ofNullable(clazz.cast(recordName()));
        case "recordSets":
            return Optional.ofNullable(clazz.cast(recordSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("hostedZoneId", HOSTED_ZONE_ID_FIELD);
        map.put("recordName", RECORD_NAME_FIELD);
        map.put("recordSets", RECORD_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route53HealthCheckConfiguration, T> g) {
        return obj -> g.apply((Route53HealthCheckConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Route53HealthCheckConfiguration> {
        /**
         * <p>
         * The Amazon Route 53 health check configuration time out (in minutes).
         * </p>
         * 
         * @param timeoutMinutes
         *        The Amazon Route 53 health check configuration time out (in minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);

        /**
         * <p>
         * The cross account role for the configuration.
         * </p>
         * 
         * @param crossAccountRole
         *        The cross account role for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountRole(String crossAccountRole);

        /**
         * <p>
         * The external ID (secret key) for the configuration.
         * </p>
         * 
         * @param externalId
         *        The external ID (secret key) for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The Amazon Route 53 health check configuration hosted zone ID.
         * </p>
         * 
         * @param hostedZoneId
         *        The Amazon Route 53 health check configuration hosted zone ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The Amazon Route 53 health check configuration record name.
         * </p>
         * 
         * @param recordName
         *        The Amazon Route 53 health check configuration record name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordName(String recordName);

        /**
         * <p>
         * The Amazon Route 53 health check configuration record sets.
         * </p>
         * 
         * @param recordSets
         *        The Amazon Route 53 health check configuration record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordSets(Collection<Route53ResourceRecordSet> recordSets);

        /**
         * <p>
         * The Amazon Route 53 health check configuration record sets.
         * </p>
         * 
         * @param recordSets
         *        The Amazon Route 53 health check configuration record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordSets(Route53ResourceRecordSet... recordSets);

        /**
         * <p>
         * The Amazon Route 53 health check configuration record sets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Route53ResourceRecordSet.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Route53ResourceRecordSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Route53ResourceRecordSet.Builder#build()} is
         * called immediately and its result is passed to {@link #recordSets(List<Route53ResourceRecordSet>)}.
         * 
         * @param recordSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Route53ResourceRecordSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordSets(java.util.Collection<Route53ResourceRecordSet>)
         */
        Builder recordSets(Consumer<Route53ResourceRecordSet.Builder>... recordSets);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutMinutes;

        private String crossAccountRole;

        private String externalId;

        private String hostedZoneId;

        private String recordName;

        private List<Route53ResourceRecordSet> recordSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Route53HealthCheckConfiguration model) {
            timeoutMinutes(model.timeoutMinutes);
            crossAccountRole(model.crossAccountRole);
            externalId(model.externalId);
            hostedZoneId(model.hostedZoneId);
            recordName(model.recordName);
            recordSets(model.recordSets);
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final String getCrossAccountRole() {
            return crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getRecordName() {
            return recordName;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final List<Route53ResourceRecordSet.Builder> getRecordSets() {
            List<Route53ResourceRecordSet.Builder> result = Route53ResourceRecordSetListCopier.copyToBuilder(this.recordSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordSets(Collection<Route53ResourceRecordSet.BuilderImpl> recordSets) {
            this.recordSets = Route53ResourceRecordSetListCopier.copyFromBuilder(recordSets);
        }

        @Override
        public final Builder recordSets(Collection<Route53ResourceRecordSet> recordSets) {
            this.recordSets = Route53ResourceRecordSetListCopier.copy(recordSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordSets(Route53ResourceRecordSet... recordSets) {
            recordSets(Arrays.asList(recordSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordSets(Consumer<Route53ResourceRecordSet.Builder>... recordSets) {
            recordSets(Stream.of(recordSets).map(c -> Route53ResourceRecordSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Route53HealthCheckConfiguration build() {
            return new Route53HealthCheckConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
