/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPlanEvaluationStatusResponse extends ArcRegionSwitchResponse implements
        ToCopyableBuilder<GetPlanEvaluationStatusResponse.Builder, GetPlanEvaluationStatusResponse> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planArn").getter(getter(GetPlanEvaluationStatusResponse::planArn)).setter(setter(Builder::planArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()).build();

    private static final SdkField<Instant> LAST_EVALUATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastEvaluationTime").getter(getter(GetPlanEvaluationStatusResponse::lastEvaluationTime))
            .setter(setter(Builder::lastEvaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEvaluationTime").build())
            .build();

    private static final SdkField<String> LAST_EVALUATED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastEvaluatedVersion").getter(getter(GetPlanEvaluationStatusResponse::lastEvaluatedVersion))
            .setter(setter(Builder::lastEvaluatedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEvaluatedVersion").build())
            .build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(GetPlanEvaluationStatusResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> EVALUATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationState").getter(getter(GetPlanEvaluationStatusResponse::evaluationStateAsString))
            .setter(setter(Builder::evaluationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationState").build()).build();

    private static final SdkField<List<ResourceWarning>> WARNINGS_FIELD = SdkField
            .<List<ResourceWarning>> builder(MarshallingType.LIST)
            .memberName("warnings")
            .getter(getter(GetPlanEvaluationStatusResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceWarning> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceWarning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetPlanEvaluationStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD,
            LAST_EVALUATION_TIME_FIELD, LAST_EVALUATED_VERSION_FIELD, REGION_FIELD, EVALUATION_STATE_FIELD, WARNINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String planArn;

    private final Instant lastEvaluationTime;

    private final String lastEvaluatedVersion;

    private final String region;

    private final String evaluationState;

    private final List<ResourceWarning> warnings;

    private final String nextToken;

    private GetPlanEvaluationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.lastEvaluationTime = builder.lastEvaluationTime;
        this.lastEvaluatedVersion = builder.lastEvaluatedVersion;
        this.region = builder.region;
        this.evaluationState = builder.evaluationState;
        this.warnings = builder.warnings;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the plan.
     */
    public final String planArn() {
        return planArn;
    }

    /**
     * <p>
     * The time of the last time that Region switch ran an evaluation of the plan.
     * </p>
     * 
     * @return The time of the last time that Region switch ran an evaluation of the plan.
     */
    public final Instant lastEvaluationTime() {
        return lastEvaluationTime;
    }

    /**
     * <p>
     * The version of the last evaluation of the plan.
     * </p>
     * 
     * @return The version of the last evaluation of the plan.
     */
    public final String lastEvaluatedVersion() {
        return lastEvaluatedVersion;
    }

    /**
     * <p>
     * The Amazon Web Services Region for the plan.
     * </p>
     * 
     * @return The Amazon Web Services Region for the plan.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The evaluation state for the plan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationState}
     * will return {@link EvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationStateAsString}.
     * </p>
     * 
     * @return The evaluation state for the plan.
     * @see EvaluationStatus
     */
    public final EvaluationStatus evaluationState() {
        return EvaluationStatus.fromValue(evaluationState);
    }

    /**
     * <p>
     * The evaluation state for the plan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationState}
     * will return {@link EvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationStateAsString}.
     * </p>
     * 
     * @return The evaluation state for the plan.
     * @see EvaluationStatus
     */
    public final String evaluationStateAsString() {
        return evaluationState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Warnings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current evaluation warnings for the plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWarnings} method.
     * </p>
     * 
     * @return The current evaluation warnings for the plan.
     */
    public final List<ResourceWarning> warnings() {
        return warnings;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>nextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>nextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>nextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>nextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(planArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlanEvaluationStatusResponse)) {
            return false;
        }
        GetPlanEvaluationStatusResponse other = (GetPlanEvaluationStatusResponse) obj;
        return Objects.equals(planArn(), other.planArn()) && Objects.equals(lastEvaluationTime(), other.lastEvaluationTime())
                && Objects.equals(lastEvaluatedVersion(), other.lastEvaluatedVersion())
                && Objects.equals(region(), other.region())
                && Objects.equals(evaluationStateAsString(), other.evaluationStateAsString())
                && hasWarnings() == other.hasWarnings() && Objects.equals(warnings(), other.warnings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPlanEvaluationStatusResponse").add("PlanArn", planArn())
                .add("LastEvaluationTime", lastEvaluationTime()).add("LastEvaluatedVersion", lastEvaluatedVersion())
                .add("Region", region()).add("EvaluationState", evaluationStateAsString())
                .add("Warnings", hasWarnings() ? warnings() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "planArn":
            return Optional.ofNullable(clazz.cast(planArn()));
        case "lastEvaluationTime":
            return Optional.ofNullable(clazz.cast(lastEvaluationTime()));
        case "lastEvaluatedVersion":
            return Optional.ofNullable(clazz.cast(lastEvaluatedVersion()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "evaluationState":
            return Optional.ofNullable(clazz.cast(evaluationStateAsString()));
        case "warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("lastEvaluationTime", LAST_EVALUATION_TIME_FIELD);
        map.put("lastEvaluatedVersion", LAST_EVALUATED_VERSION_FIELD);
        map.put("region", REGION_FIELD);
        map.put("evaluationState", EVALUATION_STATE_FIELD);
        map.put("warnings", WARNINGS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPlanEvaluationStatusResponse, T> g) {
        return obj -> g.apply((GetPlanEvaluationStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcRegionSwitchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPlanEvaluationStatusResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the plan.
         * </p>
         * 
         * @param planArn
         *        The Amazon Resource Name (ARN) of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planArn(String planArn);

        /**
         * <p>
         * The time of the last time that Region switch ran an evaluation of the plan.
         * </p>
         * 
         * @param lastEvaluationTime
         *        The time of the last time that Region switch ran an evaluation of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluationTime(Instant lastEvaluationTime);

        /**
         * <p>
         * The version of the last evaluation of the plan.
         * </p>
         * 
         * @param lastEvaluatedVersion
         *        The version of the last evaluation of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedVersion(String lastEvaluatedVersion);

        /**
         * <p>
         * The Amazon Web Services Region for the plan.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region for the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The evaluation state for the plan.
         * </p>
         * 
         * @param evaluationState
         *        The evaluation state for the plan.
         * @see EvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationStatus
         */
        Builder evaluationState(String evaluationState);

        /**
         * <p>
         * The evaluation state for the plan.
         * </p>
         * 
         * @param evaluationState
         *        The evaluation state for the plan.
         * @see EvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationStatus
         */
        Builder evaluationState(EvaluationStatus evaluationState);

        /**
         * <p>
         * The current evaluation warnings for the plan.
         * </p>
         * 
         * @param warnings
         *        The current evaluation warnings for the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<ResourceWarning> warnings);

        /**
         * <p>
         * The current evaluation warnings for the plan.
         * </p>
         * 
         * @param warnings
         *        The current evaluation warnings for the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(ResourceWarning... warnings);

        /**
         * <p>
         * The current evaluation warnings for the plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.ResourceWarning.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arcregionswitch.model.ResourceWarning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.ResourceWarning.Builder#build()} is called
         * immediately and its result is passed to {@link #warnings(List<ResourceWarning>)}.
         * 
         * @param warnings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.ResourceWarning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warnings(java.util.Collection<ResourceWarning>)
         */
        Builder warnings(Consumer<ResourceWarning.Builder>... warnings);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>nextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>nextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>nextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>nextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ArcRegionSwitchResponse.BuilderImpl implements Builder {
        private String planArn;

        private Instant lastEvaluationTime;

        private String lastEvaluatedVersion;

        private String region;

        private String evaluationState;

        private List<ResourceWarning> warnings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlanEvaluationStatusResponse model) {
            super(model);
            planArn(model.planArn);
            lastEvaluationTime(model.lastEvaluationTime);
            lastEvaluatedVersion(model.lastEvaluatedVersion);
            region(model.region);
            evaluationState(model.evaluationState);
            warnings(model.warnings);
            nextToken(model.nextToken);
        }

        public final String getPlanArn() {
            return planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final Instant getLastEvaluationTime() {
            return lastEvaluationTime;
        }

        public final void setLastEvaluationTime(Instant lastEvaluationTime) {
            this.lastEvaluationTime = lastEvaluationTime;
        }

        @Override
        public final Builder lastEvaluationTime(Instant lastEvaluationTime) {
            this.lastEvaluationTime = lastEvaluationTime;
            return this;
        }

        public final String getLastEvaluatedVersion() {
            return lastEvaluatedVersion;
        }

        public final void setLastEvaluatedVersion(String lastEvaluatedVersion) {
            this.lastEvaluatedVersion = lastEvaluatedVersion;
        }

        @Override
        public final Builder lastEvaluatedVersion(String lastEvaluatedVersion) {
            this.lastEvaluatedVersion = lastEvaluatedVersion;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getEvaluationState() {
            return evaluationState;
        }

        public final void setEvaluationState(String evaluationState) {
            this.evaluationState = evaluationState;
        }

        @Override
        public final Builder evaluationState(String evaluationState) {
            this.evaluationState = evaluationState;
            return this;
        }

        @Override
        public final Builder evaluationState(EvaluationStatus evaluationState) {
            this.evaluationState(evaluationState == null ? null : evaluationState.toString());
            return this;
        }

        public final List<ResourceWarning.Builder> getWarnings() {
            List<ResourceWarning.Builder> result = PlanWarningsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<ResourceWarning.BuilderImpl> warnings) {
            this.warnings = PlanWarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<ResourceWarning> warnings) {
            this.warnings = PlanWarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(ResourceWarning... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<ResourceWarning.Builder>... warnings) {
            warnings(Stream.of(warnings).map(c -> ResourceWarning.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetPlanEvaluationStatusResponse build() {
            return new GetPlanEvaluationStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
