/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for increasing the capacity of Amazon EC2 Auto Scaling groups during a Region switch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2AsgCapacityIncreaseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2AsgCapacityIncreaseConfiguration.Builder, Ec2AsgCapacityIncreaseConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(Ec2AsgCapacityIncreaseConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final SdkField<List<Asg>> ASGS_FIELD = SdkField
            .<List<Asg>> builder(MarshallingType.LIST)
            .memberName("asgs")
            .getter(getter(Ec2AsgCapacityIncreaseConfiguration::asgs))
            .setter(setter(Builder::asgs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asgs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Asg> builder(MarshallingType.SDK_POJO)
                                            .constructor(Asg::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Ec2Ungraceful> UNGRACEFUL_FIELD = SdkField.<Ec2Ungraceful> builder(MarshallingType.SDK_POJO)
            .memberName("ungraceful").getter(getter(Ec2AsgCapacityIncreaseConfiguration::ungraceful))
            .setter(setter(Builder::ungraceful)).constructor(Ec2Ungraceful::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()).build();

    private static final SdkField<Integer> TARGET_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("targetPercent").getter(getter(Ec2AsgCapacityIncreaseConfiguration::targetPercent))
            .setter(setter(Builder::targetPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPercent").build()).build();

    private static final SdkField<String> CAPACITY_MONITORING_APPROACH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("capacityMonitoringApproach")
            .getter(getter(Ec2AsgCapacityIncreaseConfiguration::capacityMonitoringApproachAsString))
            .setter(setter(Builder::capacityMonitoringApproach))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityMonitoringApproach").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD,
            ASGS_FIELD, UNGRACEFUL_FIELD, TARGET_PERCENT_FIELD, CAPACITY_MONITORING_APPROACH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutMinutes;

    private final List<Asg> asgs;

    private final Ec2Ungraceful ungraceful;

    private final Integer targetPercent;

    private final String capacityMonitoringApproach;

    private Ec2AsgCapacityIncreaseConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.asgs = builder.asgs;
        this.ungraceful = builder.ungraceful;
        this.targetPercent = builder.targetPercent;
        this.capacityMonitoringApproach = builder.capacityMonitoringApproach;
    }

    /**
     * <p>
     * The timeout value specified for the configuration.
     * </p>
     * 
     * @return The timeout value specified for the configuration.
     */
    public final Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Asgs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAsgs() {
        return asgs != null && !(asgs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 Auto Scaling groups for the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAsgs} method.
     * </p>
     * 
     * @return The EC2 Auto Scaling groups for the configuration.
     */
    public final List<Asg> asgs() {
        return asgs;
    }

    /**
     * <p>
     * The settings for ungraceful execution.
     * </p>
     * 
     * @return The settings for ungraceful execution.
     */
    public final Ec2Ungraceful ungraceful() {
        return ungraceful;
    }

    /**
     * <p>
     * The target percentage that you specify for EC2 Auto Scaling groups.
     * </p>
     * 
     * @return The target percentage that you specify for EC2 Auto Scaling groups.
     */
    public final Integer targetPercent() {
        return targetPercent;
    }

    /**
     * <p>
     * The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityMonitoringApproach} will return {@link Ec2AsgCapacityMonitoringApproach#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityMonitoringApproachAsString}.
     * </p>
     * 
     * @return The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
     * @see Ec2AsgCapacityMonitoringApproach
     */
    public final Ec2AsgCapacityMonitoringApproach capacityMonitoringApproach() {
        return Ec2AsgCapacityMonitoringApproach.fromValue(capacityMonitoringApproach);
    }

    /**
     * <p>
     * The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityMonitoringApproach} will return {@link Ec2AsgCapacityMonitoringApproach#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityMonitoringApproachAsString}.
     * </p>
     * 
     * @return The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
     * @see Ec2AsgCapacityMonitoringApproach
     */
    public final String capacityMonitoringApproachAsString() {
        return capacityMonitoringApproach;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasAsgs() ? asgs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ungraceful());
        hashCode = 31 * hashCode + Objects.hashCode(targetPercent());
        hashCode = 31 * hashCode + Objects.hashCode(capacityMonitoringApproachAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2AsgCapacityIncreaseConfiguration)) {
            return false;
        }
        Ec2AsgCapacityIncreaseConfiguration other = (Ec2AsgCapacityIncreaseConfiguration) obj;
        return Objects.equals(timeoutMinutes(), other.timeoutMinutes()) && hasAsgs() == other.hasAsgs()
                && Objects.equals(asgs(), other.asgs()) && Objects.equals(ungraceful(), other.ungraceful())
                && Objects.equals(targetPercent(), other.targetPercent())
                && Objects.equals(capacityMonitoringApproachAsString(), other.capacityMonitoringApproachAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2AsgCapacityIncreaseConfiguration").add("TimeoutMinutes", timeoutMinutes())
                .add("Asgs", hasAsgs() ? asgs() : null).add("Ungraceful", ungraceful()).add("TargetPercent", targetPercent())
                .add("CapacityMonitoringApproach", capacityMonitoringApproachAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        case "asgs":
            return Optional.ofNullable(clazz.cast(asgs()));
        case "ungraceful":
            return Optional.ofNullable(clazz.cast(ungraceful()));
        case "targetPercent":
            return Optional.ofNullable(clazz.cast(targetPercent()));
        case "capacityMonitoringApproach":
            return Optional.ofNullable(clazz.cast(capacityMonitoringApproachAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("asgs", ASGS_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        map.put("targetPercent", TARGET_PERCENT_FIELD);
        map.put("capacityMonitoringApproach", CAPACITY_MONITORING_APPROACH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2AsgCapacityIncreaseConfiguration, T> g) {
        return obj -> g.apply((Ec2AsgCapacityIncreaseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2AsgCapacityIncreaseConfiguration> {
        /**
         * <p>
         * The timeout value specified for the configuration.
         * </p>
         * 
         * @param timeoutMinutes
         *        The timeout value specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);

        /**
         * <p>
         * The EC2 Auto Scaling groups for the configuration.
         * </p>
         * 
         * @param asgs
         *        The EC2 Auto Scaling groups for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asgs(Collection<Asg> asgs);

        /**
         * <p>
         * The EC2 Auto Scaling groups for the configuration.
         * </p>
         * 
         * @param asgs
         *        The EC2 Auto Scaling groups for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asgs(Asg... asgs);

        /**
         * <p>
         * The EC2 Auto Scaling groups for the configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Asg.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Asg#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Asg.Builder#build()} is called immediately and
         * its result is passed to {@link #asgs(List<Asg>)}.
         * 
         * @param asgs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Asg.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asgs(java.util.Collection<Asg>)
         */
        Builder asgs(Consumer<Asg.Builder>... asgs);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * 
         * @param ungraceful
         *        The settings for ungraceful execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ungraceful(Ec2Ungraceful ungraceful);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2Ungraceful.Builder} avoiding the need
         * to create one manually via {@link Ec2Ungraceful#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2Ungraceful.Builder#build()} is called immediately and its
         * result is passed to {@link #ungraceful(Ec2Ungraceful)}.
         * 
         * @param ungraceful
         *        a consumer that will call methods on {@link Ec2Ungraceful.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ungraceful(Ec2Ungraceful)
         */
        default Builder ungraceful(Consumer<Ec2Ungraceful.Builder> ungraceful) {
            return ungraceful(Ec2Ungraceful.builder().applyMutation(ungraceful).build());
        }

        /**
         * <p>
         * The target percentage that you specify for EC2 Auto Scaling groups.
         * </p>
         * 
         * @param targetPercent
         *        The target percentage that you specify for EC2 Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPercent(Integer targetPercent);

        /**
         * <p>
         * The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
         * </p>
         * 
         * @param capacityMonitoringApproach
         *        The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
         * @see Ec2AsgCapacityMonitoringApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2AsgCapacityMonitoringApproach
         */
        Builder capacityMonitoringApproach(String capacityMonitoringApproach);

        /**
         * <p>
         * The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
         * </p>
         * 
         * @param capacityMonitoringApproach
         *        The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
         * @see Ec2AsgCapacityMonitoringApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2AsgCapacityMonitoringApproach
         */
        Builder capacityMonitoringApproach(Ec2AsgCapacityMonitoringApproach capacityMonitoringApproach);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutMinutes;

        private List<Asg> asgs = DefaultSdkAutoConstructList.getInstance();

        private Ec2Ungraceful ungraceful;

        private Integer targetPercent;

        private String capacityMonitoringApproach;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2AsgCapacityIncreaseConfiguration model) {
            timeoutMinutes(model.timeoutMinutes);
            asgs(model.asgs);
            ungraceful(model.ungraceful);
            targetPercent(model.targetPercent);
            capacityMonitoringApproach(model.capacityMonitoringApproach);
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final List<Asg.Builder> getAsgs() {
            List<Asg.Builder> result = AsgListCopier.copyToBuilder(this.asgs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAsgs(Collection<Asg.BuilderImpl> asgs) {
            this.asgs = AsgListCopier.copyFromBuilder(asgs);
        }

        @Override
        public final Builder asgs(Collection<Asg> asgs) {
            this.asgs = AsgListCopier.copy(asgs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asgs(Asg... asgs) {
            asgs(Arrays.asList(asgs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asgs(Consumer<Asg.Builder>... asgs) {
            asgs(Stream.of(asgs).map(c -> Asg.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Ec2Ungraceful.Builder getUngraceful() {
            return ungraceful != null ? ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(Ec2Ungraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(Ec2Ungraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        public final Integer getTargetPercent() {
            return targetPercent;
        }

        public final void setTargetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
        }

        @Override
        public final Builder targetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
            return this;
        }

        public final String getCapacityMonitoringApproach() {
            return capacityMonitoringApproach;
        }

        public final void setCapacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
        }

        @Override
        public final Builder capacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
            return this;
        }

        @Override
        public final Builder capacityMonitoringApproach(Ec2AsgCapacityMonitoringApproach capacityMonitoringApproach) {
            this.capacityMonitoringApproach(capacityMonitoringApproach == null ? null : capacityMonitoringApproach.toString());
            return this;
        }

        @Override
        public Ec2AsgCapacityIncreaseConfiguration build() {
            return new Ec2AsgCapacityIncreaseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
