/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for an Amazon EC2 Auto Scaling group used in a Region switch plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Asg implements SdkPojo, Serializable, ToCopyableBuilder<Asg.Builder, Asg> {
    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("crossAccountRole").getter(getter(Asg::crossAccountRole)).setter(setter(Builder::crossAccountRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(Asg::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Asg::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROSS_ACCOUNT_ROLE_FIELD,
            EXTERNAL_ID_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String crossAccountRole;

    private final String externalId;

    private final String arn;

    private Asg(BuilderImpl builder) {
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The cross account role for the configuration.
     * </p>
     * 
     * @return The cross account role for the configuration.
     */
    public final String crossAccountRole() {
        return crossAccountRole;
    }

    /**
     * <p>
     * The external ID (secret key) for the configuration.
     * </p>
     * 
     * @return The external ID (secret key) for the configuration.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the EC2 Auto Scaling group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the EC2 Auto Scaling group.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Asg)) {
            return false;
        }
        Asg other = (Asg) obj;
        return Objects.equals(crossAccountRole(), other.crossAccountRole()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Asg").add("CrossAccountRole", crossAccountRole()).add("ExternalId", externalId())
                .add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crossAccountRole":
            return Optional.ofNullable(clazz.cast(crossAccountRole()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Asg, T> g) {
        return obj -> g.apply((Asg) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Asg> {
        /**
         * <p>
         * The cross account role for the configuration.
         * </p>
         * 
         * @param crossAccountRole
         *        The cross account role for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountRole(String crossAccountRole);

        /**
         * <p>
         * The external ID (secret key) for the configuration.
         * </p>
         * 
         * @param externalId
         *        The external ID (secret key) for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the EC2 Auto Scaling group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the EC2 Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String crossAccountRole;

        private String externalId;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(Asg model) {
            crossAccountRole(model.crossAccountRole);
            externalId(model.externalId);
            arn(model.arn);
        }

        public final String getCrossAccountRole() {
            return crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public Asg build() {
            return new Asg(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
