/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the state of an ARC routing control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArcRoutingControlState implements SdkPojo, Serializable,
        ToCopyableBuilder<ArcRoutingControlState.Builder, ArcRoutingControlState> {
    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("routingControlArn").getter(getter(ArcRoutingControlState::routingControlArn))
            .setter(setter(Builder::routingControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingControlArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ArcRoutingControlState::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_CONTROL_ARN_FIELD,
            STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String routingControlArn;

    private final String state;

    private ArcRoutingControlState(BuilderImpl builder) {
        this.routingControlArn = builder.routingControlArn;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a routing control.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a routing control.
     */
    public final String routingControlArn() {
        return routingControlArn;
    }

    /**
     * <p>
     * The state of an ARC routing control, On or Off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RoutingControlStateChange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of an ARC routing control, On or Off.
     * @see RoutingControlStateChange
     */
    public final RoutingControlStateChange state() {
        return RoutingControlStateChange.fromValue(state);
    }

    /**
     * <p>
     * The state of an ARC routing control, On or Off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RoutingControlStateChange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of an ARC routing control, On or Off.
     * @see RoutingControlStateChange
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArcRoutingControlState)) {
            return false;
        }
        ArcRoutingControlState other = (ArcRoutingControlState) obj;
        return Objects.equals(routingControlArn(), other.routingControlArn())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArcRoutingControlState").add("RoutingControlArn", routingControlArn())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "routingControlArn":
            return Optional.ofNullable(clazz.cast(routingControlArn()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("routingControlArn", ROUTING_CONTROL_ARN_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArcRoutingControlState, T> g) {
        return obj -> g.apply((ArcRoutingControlState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArcRoutingControlState> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a routing control.
         * </p>
         * 
         * @param routingControlArn
         *        The Amazon Resource Name (ARN) of a routing control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlArn(String routingControlArn);

        /**
         * <p>
         * The state of an ARC routing control, On or Off.
         * </p>
         * 
         * @param state
         *        The state of an ARC routing control, On or Off.
         * @see RoutingControlStateChange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlStateChange
         */
        Builder state(String state);

        /**
         * <p>
         * The state of an ARC routing control, On or Off.
         * </p>
         * 
         * @param state
         *        The state of an ARC routing control, On or Off.
         * @see RoutingControlStateChange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingControlStateChange
         */
        Builder state(RoutingControlStateChange state);
    }

    static final class BuilderImpl implements Builder {
        private String routingControlArn;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ArcRoutingControlState model) {
            routingControlArn(model.routingControlArn);
            state(model.state);
        }

        public final String getRoutingControlArn() {
            return routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RoutingControlStateChange state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public ArcRoutingControlState build() {
            return new ArcRoutingControlState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
