/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summarized representation of a Region switch plan. This structure contains key information about a plan without all
 * the detailed workflow and step data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbbreviatedPlan implements SdkPojo, Serializable, ToCopyableBuilder<AbbreviatedPlan.Builder, AbbreviatedPlan> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AbbreviatedPlan::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(AbbreviatedPlan::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AbbreviatedPlan::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(AbbreviatedPlan::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOVERY_APPROACH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryApproach").getter(getter(AbbreviatedPlan::recoveryApproachAsString))
            .setter(setter(Builder::recoveryApproach))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryApproach").build()).build();

    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("primaryRegion").getter(getter(AbbreviatedPlan::primaryRegion)).setter(setter(Builder::primaryRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryRegion").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(AbbreviatedPlan::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(AbbreviatedPlan::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AbbreviatedPlan::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(AbbreviatedPlan::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<String> ACTIVE_PLAN_EXECUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activePlanExecution").getter(getter(AbbreviatedPlan::activePlanExecution))
            .setter(setter(Builder::activePlanExecution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activePlanExecution").build())
            .build();

    private static final SdkField<Integer> RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("recoveryTimeObjectiveMinutes")
            .getter(getter(AbbreviatedPlan::recoveryTimeObjectiveMinutes))
            .setter(setter(Builder::recoveryTimeObjectiveMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryTimeObjectiveMinutes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, OWNER_FIELD,
            NAME_FIELD, REGIONS_FIELD, RECOVERY_APPROACH_FIELD, PRIMARY_REGION_FIELD, VERSION_FIELD, UPDATED_AT_FIELD,
            DESCRIPTION_FIELD, EXECUTION_ROLE_FIELD, ACTIVE_PLAN_EXECUTION_FIELD, RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String owner;

    private final String name;

    private final List<String> regions;

    private final String recoveryApproach;

    private final String primaryRegion;

    private final String version;

    private final Instant updatedAt;

    private final String description;

    private final String executionRole;

    private final String activePlanExecution;

    private final Integer recoveryTimeObjectiveMinutes;

    private AbbreviatedPlan(BuilderImpl builder) {
        this.arn = builder.arn;
        this.owner = builder.owner;
        this.name = builder.name;
        this.regions = builder.regions;
        this.recoveryApproach = builder.recoveryApproach;
        this.primaryRegion = builder.primaryRegion;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
        this.description = builder.description;
        this.executionRole = builder.executionRole;
        this.activePlanExecution = builder.activePlanExecution;
        this.recoveryTimeObjectiveMinutes = builder.recoveryTimeObjectiveMinutes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Region switch plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Region switch plan.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The owner of a Region switch plan.
     * </p>
     * 
     * @return The owner of a Region switch plan.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The name of a Region switch plan.
     * </p>
     * 
     * @return The name of a Region switch plan.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Region specified for a Region switch plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return The Amazon Web Services Region specified for a Region switch plan.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
     * (activePassive).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recoveryApproach}
     * will return {@link RecoveryApproach#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recoveryApproachAsString}.
     * </p>
     * 
     * @return The recovery approach for a Region switch plan, which can be active/active (activeActive) or
     *         active/passive (activePassive).
     * @see RecoveryApproach
     */
    public final RecoveryApproach recoveryApproach() {
        return RecoveryApproach.fromValue(recoveryApproach);
    }

    /**
     * <p>
     * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
     * (activePassive).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recoveryApproach}
     * will return {@link RecoveryApproach#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recoveryApproachAsString}.
     * </p>
     * 
     * @return The recovery approach for a Region switch plan, which can be active/active (activeActive) or
     *         active/passive (activePassive).
     * @see RecoveryApproach
     */
    public final String recoveryApproachAsString() {
        return recoveryApproach;
    }

    /**
     * <p>
     * The primary Region for a plan.
     * </p>
     * 
     * @return The primary Region for a plan.
     */
    public final String primaryRegion() {
        return primaryRegion;
    }

    /**
     * <p>
     * The version for the plan.
     * </p>
     * 
     * @return The version for the plan.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The timestamp when the plan execution was last updated.
     * </p>
     * 
     * @return The timestamp when the plan execution was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The description of a Region switch plan.
     * </p>
     * 
     * @return The description of a Region switch plan.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The execution role is a way to categorize a Region switch plan.
     * </p>
     * 
     * @return The execution role is a way to categorize a Region switch plan.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * Specifies if this is the active plan execution at this time.
     * </p>
     * 
     * @return Specifies if this is the active plan execution at this time.
     */
    public final String activePlanExecution() {
        return activePlanExecution;
    }

    /**
     * <p>
     * The recovery time objective that you've specified.
     * </p>
     * 
     * @return The recovery time objective that you've specified.
     */
    public final Integer recoveryTimeObjectiveMinutes() {
        return recoveryTimeObjectiveMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recoveryApproachAsString());
        hashCode = 31 * hashCode + Objects.hashCode(primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(activePlanExecution());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryTimeObjectiveMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbbreviatedPlan)) {
            return false;
        }
        AbbreviatedPlan other = (AbbreviatedPlan) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(owner(), other.owner())
                && Objects.equals(name(), other.name()) && hasRegions() == other.hasRegions()
                && Objects.equals(regions(), other.regions())
                && Objects.equals(recoveryApproachAsString(), other.recoveryApproachAsString())
                && Objects.equals(primaryRegion(), other.primaryRegion()) && Objects.equals(version(), other.version())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(description(), other.description())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(activePlanExecution(), other.activePlanExecution())
                && Objects.equals(recoveryTimeObjectiveMinutes(), other.recoveryTimeObjectiveMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AbbreviatedPlan").add("Arn", arn()).add("Owner", owner()).add("Name", name())
                .add("Regions", hasRegions() ? regions() : null).add("RecoveryApproach", recoveryApproachAsString())
                .add("PrimaryRegion", primaryRegion()).add("Version", version()).add("UpdatedAt", updatedAt())
                .add("Description", description()).add("ExecutionRole", executionRole())
                .add("ActivePlanExecution", activePlanExecution())
                .add("RecoveryTimeObjectiveMinutes", recoveryTimeObjectiveMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "recoveryApproach":
            return Optional.ofNullable(clazz.cast(recoveryApproachAsString()));
        case "primaryRegion":
            return Optional.ofNullable(clazz.cast(primaryRegion()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "activePlanExecution":
            return Optional.ofNullable(clazz.cast(activePlanExecution()));
        case "recoveryTimeObjectiveMinutes":
            return Optional.ofNullable(clazz.cast(recoveryTimeObjectiveMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("recoveryApproach", RECOVERY_APPROACH_FIELD);
        map.put("primaryRegion", PRIMARY_REGION_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("activePlanExecution", ACTIVE_PLAN_EXECUTION_FIELD);
        map.put("recoveryTimeObjectiveMinutes", RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AbbreviatedPlan, T> g) {
        return obj -> g.apply((AbbreviatedPlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AbbreviatedPlan> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Region switch plan.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The owner of a Region switch plan.
         * </p>
         * 
         * @param owner
         *        The owner of a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The name of a Region switch plan.
         * </p>
         * 
         * @param name
         *        The name of a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services Region specified for a Region switch plan.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Region specified for a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The Amazon Web Services Region specified for a Region switch plan.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Region specified for a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
         * (activePassive).
         * </p>
         * 
         * @param recoveryApproach
         *        The recovery approach for a Region switch plan, which can be active/active (activeActive) or
         *        active/passive (activePassive).
         * @see RecoveryApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryApproach
         */
        Builder recoveryApproach(String recoveryApproach);

        /**
         * <p>
         * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
         * (activePassive).
         * </p>
         * 
         * @param recoveryApproach
         *        The recovery approach for a Region switch plan, which can be active/active (activeActive) or
         *        active/passive (activePassive).
         * @see RecoveryApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryApproach
         */
        Builder recoveryApproach(RecoveryApproach recoveryApproach);

        /**
         * <p>
         * The primary Region for a plan.
         * </p>
         * 
         * @param primaryRegion
         *        The primary Region for a plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryRegion(String primaryRegion);

        /**
         * <p>
         * The version for the plan.
         * </p>
         * 
         * @param version
         *        The version for the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The timestamp when the plan execution was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the plan execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The description of a Region switch plan.
         * </p>
         * 
         * @param description
         *        The description of a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The execution role is a way to categorize a Region switch plan.
         * </p>
         * 
         * @param executionRole
         *        The execution role is a way to categorize a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * Specifies if this is the active plan execution at this time.
         * </p>
         * 
         * @param activePlanExecution
         *        Specifies if this is the active plan execution at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activePlanExecution(String activePlanExecution);

        /**
         * <p>
         * The recovery time objective that you've specified.
         * </p>
         * 
         * @param recoveryTimeObjectiveMinutes
         *        The recovery time objective that you've specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String owner;

        private String name;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String recoveryApproach;

        private String primaryRegion;

        private String version;

        private Instant updatedAt;

        private String description;

        private String executionRole;

        private String activePlanExecution;

        private Integer recoveryTimeObjectiveMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(AbbreviatedPlan model) {
            arn(model.arn);
            owner(model.owner);
            name(model.name);
            regions(model.regions);
            recoveryApproach(model.recoveryApproach);
            primaryRegion(model.primaryRegion);
            version(model.version);
            updatedAt(model.updatedAt);
            description(model.description);
            executionRole(model.executionRole);
            activePlanExecution(model.activePlanExecution);
            recoveryTimeObjectiveMinutes(model.recoveryTimeObjectiveMinutes);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final String getRecoveryApproach() {
            return recoveryApproach;
        }

        public final void setRecoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
        }

        @Override
        public final Builder recoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
            return this;
        }

        @Override
        public final Builder recoveryApproach(RecoveryApproach recoveryApproach) {
            this.recoveryApproach(recoveryApproach == null ? null : recoveryApproach.toString());
            return this;
        }

        public final String getPrimaryRegion() {
            return primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getActivePlanExecution() {
            return activePlanExecution;
        }

        public final void setActivePlanExecution(String activePlanExecution) {
            this.activePlanExecution = activePlanExecution;
        }

        @Override
        public final Builder activePlanExecution(String activePlanExecution) {
            this.activePlanExecution = activePlanExecution;
            return this;
        }

        public final Integer getRecoveryTimeObjectiveMinutes() {
            return recoveryTimeObjectiveMinutes;
        }

        public final void setRecoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
        }

        @Override
        public final Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
            return this;
        }

        @Override
        public AbbreviatedPlan build() {
            return new AbbreviatedPlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
