/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arcregionswitch.model.AlarmType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatedAlarm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociatedAlarm> {
    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("crossAccountRole").getter(AssociatedAlarm.getter(AssociatedAlarm::crossAccountRole)).setter(AssociatedAlarm.setter(Builder::crossAccountRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(AssociatedAlarm.getter(AssociatedAlarm::externalId)).setter(AssociatedAlarm.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceIdentifier").getter(AssociatedAlarm.getter(AssociatedAlarm::resourceIdentifier)).setter(AssociatedAlarm.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<String> ALARM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmType").getter(AssociatedAlarm.getter(AssociatedAlarm::alarmTypeAsString)).setter(AssociatedAlarm.setter(Builder::alarmType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROSS_ACCOUNT_ROLE_FIELD, EXTERNAL_ID_FIELD, RESOURCE_IDENTIFIER_FIELD, ALARM_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociatedAlarm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String crossAccountRole;
    private final String externalId;
    private final String resourceIdentifier;
    private final String alarmType;

    private AssociatedAlarm(BuilderImpl builder) {
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.alarmType = builder.alarmType;
    }

    public final String crossAccountRole() {
        return this.crossAccountRole;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final AlarmType alarmType() {
        return AlarmType.fromValue(this.alarmType);
    }

    public final String alarmTypeAsString() {
        return this.alarmType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedAlarm)) {
            return false;
        }
        AssociatedAlarm other = (AssociatedAlarm)obj;
        return Objects.equals(this.crossAccountRole(), other.crossAccountRole()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.alarmTypeAsString(), other.alarmTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatedAlarm").add("CrossAccountRole", (Object)this.crossAccountRole()).add("ExternalId", (Object)this.externalId()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("AlarmType", (Object)this.alarmTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crossAccountRole": {
                return Optional.ofNullable(clazz.cast(this.crossAccountRole()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "alarmType": {
                return Optional.ofNullable(clazz.cast(this.alarmTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("alarmType", ALARM_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedAlarm, T> g) {
        return obj -> g.apply((AssociatedAlarm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String crossAccountRole;
        private String externalId;
        private String resourceIdentifier;
        private String alarmType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedAlarm model) {
            this.crossAccountRole(model.crossAccountRole);
            this.externalId(model.externalId);
            this.resourceIdentifier(model.resourceIdentifier);
            this.alarmType(model.alarmType);
        }

        public final String getCrossAccountRole() {
            return this.crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getAlarmType() {
            return this.alarmType;
        }

        public final void setAlarmType(String alarmType) {
            this.alarmType = alarmType;
        }

        @Override
        public final Builder alarmType(String alarmType) {
            this.alarmType = alarmType;
            return this;
        }

        @Override
        public final Builder alarmType(AlarmType alarmType) {
            this.alarmType(alarmType == null ? null : alarmType.toString());
            return this;
        }

        public AssociatedAlarm build() {
            return new AssociatedAlarm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociatedAlarm> {
        public Builder crossAccountRole(String var1);

        public Builder externalId(String var1);

        public Builder resourceIdentifier(String var1);

        public Builder alarmType(String var1);

        public Builder alarmType(AlarmType var1);
    }
}

