/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionAction;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionMode;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AbbreviatedExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AbbreviatedExecution> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planArn").getter(AbbreviatedExecution.getter(AbbreviatedExecution::planArn)).setter(AbbreviatedExecution.setter(Builder::planArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(AbbreviatedExecution.getter(AbbreviatedExecution::executionId)).setter(AbbreviatedExecution.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(AbbreviatedExecution.getter(AbbreviatedExecution::version)).setter(AbbreviatedExecution.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AbbreviatedExecution.getter(AbbreviatedExecution::updatedAt)).setter(AbbreviatedExecution.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(AbbreviatedExecution.getter(AbbreviatedExecution::comment)).setter(AbbreviatedExecution.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(AbbreviatedExecution.getter(AbbreviatedExecution::startTime)).setter(AbbreviatedExecution.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(AbbreviatedExecution.getter(AbbreviatedExecution::endTime)).setter(AbbreviatedExecution.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(AbbreviatedExecution.getter(AbbreviatedExecution::modeAsString)).setter(AbbreviatedExecution.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<String> EXECUTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionState").getter(AbbreviatedExecution.getter(AbbreviatedExecution::executionStateAsString)).setter(AbbreviatedExecution.setter(Builder::executionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionState").build()}).build();
    private static final SdkField<String> EXECUTION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionAction").getter(AbbreviatedExecution.getter(AbbreviatedExecution::executionActionAsString)).setter(AbbreviatedExecution.setter(Builder::executionAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionAction").build()}).build();
    private static final SdkField<String> EXECUTION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRegion").getter(AbbreviatedExecution.getter(AbbreviatedExecution::executionRegion)).setter(AbbreviatedExecution.setter(Builder::executionRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRegion").build()}).build();
    private static final SdkField<String> ACTUAL_RECOVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actualRecoveryTime").getter(AbbreviatedExecution.getter(AbbreviatedExecution::actualRecoveryTime)).setter(AbbreviatedExecution.setter(Builder::actualRecoveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualRecoveryTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD, EXECUTION_ID_FIELD, VERSION_FIELD, UPDATED_AT_FIELD, COMMENT_FIELD, START_TIME_FIELD, END_TIME_FIELD, MODE_FIELD, EXECUTION_STATE_FIELD, EXECUTION_ACTION_FIELD, EXECUTION_REGION_FIELD, ACTUAL_RECOVERY_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AbbreviatedExecution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String planArn;
    private final String executionId;
    private final String version;
    private final Instant updatedAt;
    private final String comment;
    private final Instant startTime;
    private final Instant endTime;
    private final String mode;
    private final String executionState;
    private final String executionAction;
    private final String executionRegion;
    private final String actualRecoveryTime;

    private AbbreviatedExecution(BuilderImpl builder) {
        this.planArn = builder.planArn;
        this.executionId = builder.executionId;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
        this.comment = builder.comment;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.mode = builder.mode;
        this.executionState = builder.executionState;
        this.executionAction = builder.executionAction;
        this.executionRegion = builder.executionRegion;
        this.actualRecoveryTime = builder.actualRecoveryTime;
    }

    public final String planArn() {
        return this.planArn;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String version() {
        return this.version;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String comment() {
        return this.comment;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final ExecutionState executionState() {
        return ExecutionState.fromValue(this.executionState);
    }

    public final String executionStateAsString() {
        return this.executionState;
    }

    public final ExecutionAction executionAction() {
        return ExecutionAction.fromValue(this.executionAction);
    }

    public final String executionActionAsString() {
        return this.executionAction;
    }

    public final String executionRegion() {
        return this.executionRegion;
    }

    public final String actualRecoveryTime() {
        return this.actualRecoveryTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.planArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualRecoveryTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbbreviatedExecution)) {
            return false;
        }
        AbbreviatedExecution other = (AbbreviatedExecution)obj;
        return Objects.equals(this.planArn(), other.planArn()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.executionStateAsString(), other.executionStateAsString()) && Objects.equals(this.executionActionAsString(), other.executionActionAsString()) && Objects.equals(this.executionRegion(), other.executionRegion()) && Objects.equals(this.actualRecoveryTime(), other.actualRecoveryTime());
    }

    public final String toString() {
        return ToString.builder((String)"AbbreviatedExecution").add("PlanArn", (Object)this.planArn()).add("ExecutionId", (Object)this.executionId()).add("Version", (Object)this.version()).add("UpdatedAt", (Object)this.updatedAt()).add("Comment", (Object)this.comment()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Mode", (Object)this.modeAsString()).add("ExecutionState", (Object)this.executionStateAsString()).add("ExecutionAction", (Object)this.executionActionAsString()).add("ExecutionRegion", (Object)this.executionRegion()).add("ActualRecoveryTime", (Object)this.actualRecoveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "planArn": {
                return Optional.ofNullable(clazz.cast(this.planArn()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "executionState": {
                return Optional.ofNullable(clazz.cast(this.executionStateAsString()));
            }
            case "executionAction": {
                return Optional.ofNullable(clazz.cast(this.executionActionAsString()));
            }
            case "executionRegion": {
                return Optional.ofNullable(clazz.cast(this.executionRegion()));
            }
            case "actualRecoveryTime": {
                return Optional.ofNullable(clazz.cast(this.actualRecoveryTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("executionState", EXECUTION_STATE_FIELD);
        map.put("executionAction", EXECUTION_ACTION_FIELD);
        map.put("executionRegion", EXECUTION_REGION_FIELD);
        map.put("actualRecoveryTime", ACTUAL_RECOVERY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AbbreviatedExecution, T> g) {
        return obj -> g.apply((AbbreviatedExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String planArn;
        private String executionId;
        private String version;
        private Instant updatedAt;
        private String comment;
        private Instant startTime;
        private Instant endTime;
        private String mode;
        private String executionState;
        private String executionAction;
        private String executionRegion;
        private String actualRecoveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AbbreviatedExecution model) {
            this.planArn(model.planArn);
            this.executionId(model.executionId);
            this.version(model.version);
            this.updatedAt(model.updatedAt);
            this.comment(model.comment);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.mode(model.mode);
            this.executionState(model.executionState);
            this.executionAction(model.executionAction);
            this.executionRegion(model.executionRegion);
            this.actualRecoveryTime(model.actualRecoveryTime);
        }

        public final String getPlanArn() {
            return this.planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getExecutionState() {
            return this.executionState;
        }

        public final void setExecutionState(String executionState) {
            this.executionState = executionState;
        }

        @Override
        public final Builder executionState(String executionState) {
            this.executionState = executionState;
            return this;
        }

        @Override
        public final Builder executionState(ExecutionState executionState) {
            this.executionState(executionState == null ? null : executionState.toString());
            return this;
        }

        public final String getExecutionAction() {
            return this.executionAction;
        }

        public final void setExecutionAction(String executionAction) {
            this.executionAction = executionAction;
        }

        @Override
        public final Builder executionAction(String executionAction) {
            this.executionAction = executionAction;
            return this;
        }

        @Override
        public final Builder executionAction(ExecutionAction executionAction) {
            this.executionAction(executionAction == null ? null : executionAction.toString());
            return this;
        }

        public final String getExecutionRegion() {
            return this.executionRegion;
        }

        public final void setExecutionRegion(String executionRegion) {
            this.executionRegion = executionRegion;
        }

        @Override
        public final Builder executionRegion(String executionRegion) {
            this.executionRegion = executionRegion;
            return this;
        }

        public final String getActualRecoveryTime() {
            return this.actualRecoveryTime;
        }

        public final void setActualRecoveryTime(String actualRecoveryTime) {
            this.actualRecoveryTime = actualRecoveryTime;
        }

        @Override
        public final Builder actualRecoveryTime(String actualRecoveryTime) {
            this.actualRecoveryTime = actualRecoveryTime;
            return this;
        }

        public AbbreviatedExecution build() {
            return new AbbreviatedExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AbbreviatedExecution> {
        public Builder planArn(String var1);

        public Builder executionId(String var1);

        public Builder version(String var1);

        public Builder updatedAt(Instant var1);

        public Builder comment(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder mode(String var1);

        public Builder mode(ExecutionMode var1);

        public Builder executionState(String var1);

        public Builder executionState(ExecutionState var1);

        public Builder executionAction(String var1);

        public Builder executionAction(ExecutionAction var1);

        public Builder executionRegion(String var1);

        public Builder actualRecoveryTime(String var1);
    }
}

