/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePlanRequest extends ArcRegionSwitchRequest implements
        ToCopyableBuilder<UpdatePlanRequest.Builder, UpdatePlanRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdatePlanRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdatePlanRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField
            .<List<Workflow>> builder(MarshallingType.LIST)
            .memberName("workflows")
            .getter(getter(UpdatePlanRequest::workflows))
            .setter(setter(Builder::workflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workflow> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workflow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(UpdatePlanRequest::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<Integer> RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("recoveryTimeObjectiveMinutes")
            .getter(getter(UpdatePlanRequest::recoveryTimeObjectiveMinutes))
            .setter(setter(Builder::recoveryTimeObjectiveMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryTimeObjectiveMinutes")
                    .build()).build();

    private static final SdkField<Map<String, AssociatedAlarm>> ASSOCIATED_ALARMS_FIELD = SdkField
            .<Map<String, AssociatedAlarm>> builder(MarshallingType.MAP)
            .memberName("associatedAlarms")
            .getter(getter(UpdatePlanRequest::associatedAlarms))
            .setter(setter(Builder::associatedAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAlarms").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AssociatedAlarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedAlarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField
            .<List<Trigger>> builder(MarshallingType.LIST)
            .memberName("triggers")
            .getter(getter(UpdatePlanRequest::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ARN_FIELD, DESCRIPTION_FIELD, WORKFLOWS_FIELD, EXECUTION_ROLE_FIELD, RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD,
                    ASSOCIATED_ALARMS_FIELD, TRIGGERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String description;

    private final List<Workflow> workflows;

    private final String executionRole;

    private final Integer recoveryTimeObjectiveMinutes;

    private final Map<String, AssociatedAlarm> associatedAlarms;

    private final List<Trigger> triggers;

    private UpdatePlanRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.workflows = builder.workflows;
        this.executionRole = builder.executionRole;
        this.recoveryTimeObjectiveMinutes = builder.recoveryTimeObjectiveMinutes;
        this.associatedAlarms = builder.associatedAlarms;
        this.triggers = builder.triggers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the plan.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The updated description for the Region switch plan.
     * </p>
     * 
     * @return The updated description for the Region switch plan.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workflows property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkflows() {
        return workflows != null && !(workflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated workflows for the Region switch plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflows} method.
     * </p>
     * 
     * @return The updated workflows for the Region switch plan.
     */
    public final List<Workflow> workflows() {
        return workflows;
    }

    /**
     * <p>
     * The updated IAM role ARN that grants Region switch the permissions needed to execute the plan steps.
     * </p>
     * 
     * @return The updated IAM role ARN that grants Region switch the permissions needed to execute the plan steps.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The updated target recovery time objective (RTO) in minutes for the plan.
     * </p>
     * 
     * @return The updated target recovery time objective (RTO) in minutes for the plan.
     */
    public final Integer recoveryTimeObjectiveMinutes() {
        return recoveryTimeObjectiveMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedAlarms() {
        return associatedAlarms != null && !(associatedAlarms instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The updated CloudWatch alarms associated with the plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedAlarms} method.
     * </p>
     * 
     * @return The updated CloudWatch alarms associated with the plan.
     */
    public final Map<String, AssociatedAlarm> associatedAlarms() {
        return associatedAlarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Triggers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated conditions that can automatically trigger the execution of the plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggers} method.
     * </p>
     * 
     * @return The updated conditions that can automatically trigger the execution of the plan.
     */
    public final List<Trigger> triggers() {
        return triggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflows() ? workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryTimeObjectiveMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedAlarms() ? associatedAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePlanRequest)) {
            return false;
        }
        UpdatePlanRequest other = (UpdatePlanRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && hasWorkflows() == other.hasWorkflows() && Objects.equals(workflows(), other.workflows())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(recoveryTimeObjectiveMinutes(), other.recoveryTimeObjectiveMinutes())
                && hasAssociatedAlarms() == other.hasAssociatedAlarms()
                && Objects.equals(associatedAlarms(), other.associatedAlarms()) && hasTriggers() == other.hasTriggers()
                && Objects.equals(triggers(), other.triggers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePlanRequest").add("Arn", arn()).add("Description", description())
                .add("Workflows", hasWorkflows() ? workflows() : null).add("ExecutionRole", executionRole())
                .add("RecoveryTimeObjectiveMinutes", recoveryTimeObjectiveMinutes())
                .add("AssociatedAlarms", hasAssociatedAlarms() ? associatedAlarms() : null)
                .add("Triggers", hasTriggers() ? triggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "workflows":
            return Optional.ofNullable(clazz.cast(workflows()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "recoveryTimeObjectiveMinutes":
            return Optional.ofNullable(clazz.cast(recoveryTimeObjectiveMinutes()));
        case "associatedAlarms":
            return Optional.ofNullable(clazz.cast(associatedAlarms()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("workflows", WORKFLOWS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("recoveryTimeObjectiveMinutes", RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD);
        map.put("associatedAlarms", ASSOCIATED_ALARMS_FIELD);
        map.put("triggers", TRIGGERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePlanRequest, T> g) {
        return obj -> g.apply((UpdatePlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcRegionSwitchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePlanRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the plan.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The updated description for the Region switch plan.
         * </p>
         * 
         * @param description
         *        The updated description for the Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated workflows for the Region switch plan.
         * </p>
         * 
         * @param workflows
         *        The updated workflows for the Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Collection<Workflow> workflows);

        /**
         * <p>
         * The updated workflows for the Region switch plan.
         * </p>
         * 
         * @param workflows
         *        The updated workflows for the Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Workflow... workflows);

        /**
         * <p>
         * The updated workflows for the Region switch plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow.Builder#build()} is called immediately
         * and its result is passed to {@link #workflows(List<Workflow>)}.
         * 
         * @param workflows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflows(java.util.Collection<Workflow>)
         */
        Builder workflows(Consumer<Workflow.Builder>... workflows);

        /**
         * <p>
         * The updated IAM role ARN that grants Region switch the permissions needed to execute the plan steps.
         * </p>
         * 
         * @param executionRole
         *        The updated IAM role ARN that grants Region switch the permissions needed to execute the plan steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The updated target recovery time objective (RTO) in minutes for the plan.
         * </p>
         * 
         * @param recoveryTimeObjectiveMinutes
         *        The updated target recovery time objective (RTO) in minutes for the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes);

        /**
         * <p>
         * The updated CloudWatch alarms associated with the plan.
         * </p>
         * 
         * @param associatedAlarms
         *        The updated CloudWatch alarms associated with the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAlarms(Map<String, AssociatedAlarm> associatedAlarms);

        /**
         * <p>
         * The updated conditions that can automatically trigger the execution of the plan.
         * </p>
         * 
         * @param triggers
         *        The updated conditions that can automatically trigger the execution of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<Trigger> triggers);

        /**
         * <p>
         * The updated conditions that can automatically trigger the execution of the plan.
         * </p>
         * 
         * @param triggers
         *        The updated conditions that can automatically trigger the execution of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Trigger... triggers);

        /**
         * <p>
         * The updated conditions that can automatically trigger the execution of the plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger.Builder#build()} is called immediately
         * and its result is passed to {@link #triggers(List<Trigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(java.util.Collection<Trigger>)
         */
        Builder triggers(Consumer<Trigger.Builder>... triggers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcRegionSwitchRequest.BuilderImpl implements Builder {
        private String arn;

        private String description;

        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();

        private String executionRole;

        private Integer recoveryTimeObjectiveMinutes;

        private Map<String, AssociatedAlarm> associatedAlarms = DefaultSdkAutoConstructMap.getInstance();

        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePlanRequest model) {
            super(model);
            arn(model.arn);
            description(model.description);
            workflows(model.workflows);
            executionRole(model.executionRole);
            recoveryTimeObjectiveMinutes(model.recoveryTimeObjectiveMinutes);
            associatedAlarms(model.associatedAlarms);
            triggers(model.triggers);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Workflow.Builder> getWorkflows() {
            List<Workflow.Builder> result = WorkflowListCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowListCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowListCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow... workflows) {
            workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder>... workflows) {
            workflows(Stream.of(workflows).map(c -> Workflow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getRecoveryTimeObjectiveMinutes() {
            return recoveryTimeObjectiveMinutes;
        }

        public final void setRecoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
        }

        @Override
        public final Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
            return this;
        }

        public final Map<String, AssociatedAlarm.Builder> getAssociatedAlarms() {
            Map<String, AssociatedAlarm.Builder> result = AssociatedAlarmMapCopier.copyToBuilder(this.associatedAlarms);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssociatedAlarms(Map<String, AssociatedAlarm.BuilderImpl> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copyFromBuilder(associatedAlarms);
        }

        @Override
        public final Builder associatedAlarms(Map<String, AssociatedAlarm> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copy(associatedAlarms);
            return this;
        }

        public final List<Trigger.Builder> getTriggers() {
            List<Trigger.Builder> result = TriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> Trigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePlanRequest build() {
            return new UpdatePlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
