/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Route53ResourceRecordSetListCopier {
    static List<Route53ResourceRecordSet> copy(Collection<? extends Route53ResourceRecordSet> route53ResourceRecordSetListParam) {
        List<Route53ResourceRecordSet> list;
        if (route53ResourceRecordSetListParam == null || route53ResourceRecordSetListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Route53ResourceRecordSet> modifiableList = new ArrayList<>(route53ResourceRecordSetListParam.size());
            route53ResourceRecordSetListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Route53ResourceRecordSet> copyFromBuilder(
            Collection<? extends Route53ResourceRecordSet.Builder> route53ResourceRecordSetListParam) {
        List<Route53ResourceRecordSet> list;
        if (route53ResourceRecordSetListParam == null || route53ResourceRecordSetListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Route53ResourceRecordSet> modifiableList = new ArrayList<>(route53ResourceRecordSetListParam.size());
            route53ResourceRecordSetListParam.forEach(entry -> {
                Route53ResourceRecordSet member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Route53ResourceRecordSet.Builder> copyToBuilder(
            Collection<? extends Route53ResourceRecordSet> route53ResourceRecordSetListParam) {
        List<Route53ResourceRecordSet.Builder> list;
        if (route53ResourceRecordSetListParam == null || route53ResourceRecordSetListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Route53ResourceRecordSet.Builder> modifiableList = new ArrayList<>(route53ResourceRecordSetListParam.size());
            route53ResourceRecordSetListParam.forEach(entry -> {
                Route53ResourceRecordSet.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
