/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Route 53 record set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Route53ResourceRecordSet implements SdkPojo, Serializable,
        ToCopyableBuilder<Route53ResourceRecordSet.Builder, Route53ResourceRecordSet> {
    private static final SdkField<String> RECORD_SET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordSetIdentifier").getter(getter(Route53ResourceRecordSet::recordSetIdentifier))
            .setter(setter(Builder::recordSetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordSetIdentifier").build())
            .build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(Route53ResourceRecordSet::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_SET_IDENTIFIER_FIELD,
            REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recordSetIdentifier;

    private final String region;

    private Route53ResourceRecordSet(BuilderImpl builder) {
        this.recordSetIdentifier = builder.recordSetIdentifier;
        this.region = builder.region;
    }

    /**
     * <p>
     * The Amazon Route 53 record set identifier.
     * </p>
     * 
     * @return The Amazon Route 53 record set identifier.
     */
    public final String recordSetIdentifier() {
        return recordSetIdentifier;
    }

    /**
     * <p>
     * The Amazon Route 53 record set Region.
     * </p>
     * 
     * @return The Amazon Route 53 record set Region.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route53ResourceRecordSet)) {
            return false;
        }
        Route53ResourceRecordSet other = (Route53ResourceRecordSet) obj;
        return Objects.equals(recordSetIdentifier(), other.recordSetIdentifier()) && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Route53ResourceRecordSet").add("RecordSetIdentifier", recordSetIdentifier())
                .add("Region", region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordSetIdentifier":
            return Optional.ofNullable(clazz.cast(recordSetIdentifier()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recordSetIdentifier", RECORD_SET_IDENTIFIER_FIELD);
        map.put("region", REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route53ResourceRecordSet, T> g) {
        return obj -> g.apply((Route53ResourceRecordSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Route53ResourceRecordSet> {
        /**
         * <p>
         * The Amazon Route 53 record set identifier.
         * </p>
         * 
         * @param recordSetIdentifier
         *        The Amazon Route 53 record set identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordSetIdentifier(String recordSetIdentifier);

        /**
         * <p>
         * The Amazon Route 53 record set Region.
         * </p>
         * 
         * @param region
         *        The Amazon Route 53 record set Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private String recordSetIdentifier;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(Route53ResourceRecordSet model) {
            recordSetIdentifier(model.recordSetIdentifier);
            region(model.region);
        }

        public final String getRecordSetIdentifier() {
            return recordSetIdentifier;
        }

        public final void setRecordSetIdentifier(String recordSetIdentifier) {
            this.recordSetIdentifier = recordSetIdentifier;
        }

        @Override
        public final Builder recordSetIdentifier(String recordSetIdentifier) {
            this.recordSetIdentifier = recordSetIdentifier;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public Route53ResourceRecordSet build() {
            return new Route53ResourceRecordSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
