/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for handling failures when performing operations on EC2 resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2Ungraceful implements SdkPojo, Serializable, ToCopyableBuilder<Ec2Ungraceful.Builder, Ec2Ungraceful> {
    private static final SdkField<Integer> MINIMUM_SUCCESS_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumSuccessPercentage").getter(getter(Ec2Ungraceful::minimumSuccessPercentage))
            .setter(setter(Builder::minimumSuccessPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumSuccessPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MINIMUM_SUCCESS_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minimumSuccessPercentage;

    private Ec2Ungraceful(BuilderImpl builder) {
        this.minimumSuccessPercentage = builder.minimumSuccessPercentage;
    }

    /**
     * <p>
     * The minimum success percentage that you specify for EC2 Auto Scaling groups.
     * </p>
     * 
     * @return The minimum success percentage that you specify for EC2 Auto Scaling groups.
     */
    public final Integer minimumSuccessPercentage() {
        return minimumSuccessPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumSuccessPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2Ungraceful)) {
            return false;
        }
        Ec2Ungraceful other = (Ec2Ungraceful) obj;
        return Objects.equals(minimumSuccessPercentage(), other.minimumSuccessPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2Ungraceful").add("MinimumSuccessPercentage", minimumSuccessPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minimumSuccessPercentage":
            return Optional.ofNullable(clazz.cast(minimumSuccessPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("minimumSuccessPercentage", MINIMUM_SUCCESS_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2Ungraceful, T> g) {
        return obj -> g.apply((Ec2Ungraceful) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2Ungraceful> {
        /**
         * <p>
         * The minimum success percentage that you specify for EC2 Auto Scaling groups.
         * </p>
         * 
         * @param minimumSuccessPercentage
         *        The minimum success percentage that you specify for EC2 Auto Scaling groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumSuccessPercentage(Integer minimumSuccessPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Integer minimumSuccessPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2Ungraceful model) {
            minimumSuccessPercentage(model.minimumSuccessPercentage);
        }

        public final Integer getMinimumSuccessPercentage() {
            return minimumSuccessPercentage;
        }

        public final void setMinimumSuccessPercentage(Integer minimumSuccessPercentage) {
            this.minimumSuccessPercentage = minimumSuccessPercentage;
        }

        @Override
        public final Builder minimumSuccessPercentage(Integer minimumSuccessPercentage) {
            this.minimumSuccessPercentage = minimumSuccessPercentage;
            return this;
        }

        @Override
        public Ec2Ungraceful build() {
            return new Ec2Ungraceful(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
