/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusResponse;
import software.amazon.awssdk.services.arcregionswitch.model.ResourceWarning;

public class GetPlanEvaluationStatusIterable
implements SdkIterable<GetPlanEvaluationStatusResponse> {
    private final ArcRegionSwitchClient client;
    private final GetPlanEvaluationStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetPlanEvaluationStatusIterable(ArcRegionSwitchClient client, GetPlanEvaluationStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetPlanEvaluationStatusResponseFetcher();
    }

    public Iterator<GetPlanEvaluationStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceWarning> warnings() {
        Function<GetPlanEvaluationStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.warnings() != null) {
                return response.warnings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetPlanEvaluationStatusResponseFetcher
    implements SyncPageFetcher<GetPlanEvaluationStatusResponse> {
        private GetPlanEvaluationStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetPlanEvaluationStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetPlanEvaluationStatusResponse nextPage(GetPlanEvaluationStatusResponse previousPage) {
            if (previousPage == null) {
                return GetPlanEvaluationStatusIterable.this.client.getPlanEvaluationStatus(GetPlanEvaluationStatusIterable.this.firstRequest);
            }
            return GetPlanEvaluationStatusIterable.this.client.getPlanEvaluationStatus((GetPlanEvaluationStatusRequest)((Object)GetPlanEvaluationStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

