/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionBlockType;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionEventType;
import software.amazon.awssdk.services.arcregionswitch.model.ResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionEvent> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(ExecutionEvent.getter(ExecutionEvent::timestamp)).setter(ExecutionEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ExecutionEvent.getter(ExecutionEvent::typeAsString)).setter(ExecutionEvent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepName").getter(ExecutionEvent.getter(ExecutionEvent::stepName)).setter(ExecutionEvent.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()}).build();
    private static final SdkField<String> EXECUTION_BLOCK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionBlockType").getter(ExecutionEvent.getter(ExecutionEvent::executionBlockTypeAsString)).setter(ExecutionEvent.setter(Builder::executionBlockType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionBlockType").build()}).build();
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(ExecutionEvent.getter(ExecutionEvent::resources)).setter(ExecutionEvent.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(ExecutionEvent.getter(ExecutionEvent::error)).setter(ExecutionEvent.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ExecutionEvent.getter(ExecutionEvent::description)).setter(ExecutionEvent.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(ExecutionEvent.getter(ExecutionEvent::eventId)).setter(ExecutionEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> PREVIOUS_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("previousEventId").getter(ExecutionEvent.getter(ExecutionEvent::previousEventId)).setter(ExecutionEvent.setter(Builder::previousEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousEventId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, TYPE_FIELD, STEP_NAME_FIELD, EXECUTION_BLOCK_TYPE_FIELD, RESOURCES_FIELD, ERROR_FIELD, DESCRIPTION_FIELD, EVENT_ID_FIELD, PREVIOUS_EVENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final String type;
    private final String stepName;
    private final String executionBlockType;
    private final List<String> resources;
    private final String error;
    private final String description;
    private final String eventId;
    private final String previousEventId;

    private ExecutionEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.type = builder.type;
        this.stepName = builder.stepName;
        this.executionBlockType = builder.executionBlockType;
        this.resources = builder.resources;
        this.error = builder.error;
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.previousEventId = builder.previousEventId;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final ExecutionEventType type() {
        return ExecutionEventType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String stepName() {
        return this.stepName;
    }

    public final ExecutionBlockType executionBlockType() {
        return ExecutionBlockType.fromValue(this.executionBlockType);
    }

    public final String executionBlockTypeAsString() {
        return this.executionBlockType;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<String> resources() {
        return this.resources;
    }

    public final String error() {
        return this.error;
    }

    public final String description() {
        return this.description;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String previousEventId() {
        return this.previousEventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionBlockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousEventId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionEvent)) {
            return false;
        }
        ExecutionEvent other = (ExecutionEvent)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.executionBlockTypeAsString(), other.executionBlockTypeAsString()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.previousEventId(), other.previousEventId());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionEvent").add("Timestamp", (Object)this.timestamp()).add("Type", (Object)this.typeAsString()).add("StepName", (Object)this.stepName()).add("ExecutionBlockType", (Object)this.executionBlockTypeAsString()).add("Resources", this.hasResources() ? this.resources() : null).add("Error", (Object)this.error()).add("Description", (Object)this.description()).add("EventId", (Object)this.eventId()).add("PreviousEventId", (Object)this.previousEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "stepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "executionBlockType": {
                return Optional.ofNullable(clazz.cast(this.executionBlockTypeAsString()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "previousEventId": {
                return Optional.ofNullable(clazz.cast(this.previousEventId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("stepName", STEP_NAME_FIELD);
        map.put("executionBlockType", EXECUTION_BLOCK_TYPE_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("previousEventId", PREVIOUS_EVENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionEvent, T> g) {
        return obj -> g.apply((ExecutionEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private String type;
        private String stepName;
        private String executionBlockType;
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();
        private String error;
        private String description;
        private String eventId;
        private String previousEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionEvent model) {
            this.timestamp(model.timestamp);
            this.type(model.type);
            this.stepName(model.stepName);
            this.executionBlockType(model.executionBlockType);
            this.resources(model.resources);
            this.error(model.error);
            this.description(model.description);
            this.eventId(model.eventId);
            this.previousEventId(model.previousEventId);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ExecutionEventType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStepName() {
            return this.stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getExecutionBlockType() {
            return this.executionBlockType;
        }

        public final void setExecutionBlockType(String executionBlockType) {
            this.executionBlockType = executionBlockType;
        }

        @Override
        public final Builder executionBlockType(String executionBlockType) {
            this.executionBlockType = executionBlockType;
            return this;
        }

        @Override
        public final Builder executionBlockType(ExecutionBlockType executionBlockType) {
            this.executionBlockType(executionBlockType == null ? null : executionBlockType.toString());
            return this;
        }

        public final Collection<String> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getPreviousEventId() {
            return this.previousEventId;
        }

        public final void setPreviousEventId(String previousEventId) {
            this.previousEventId = previousEventId;
        }

        @Override
        public final Builder previousEventId(String previousEventId) {
            this.previousEventId = previousEventId;
            return this;
        }

        public ExecutionEvent build() {
            return new ExecutionEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionEvent> {
        public Builder timestamp(Instant var1);

        public Builder type(String var1);

        public Builder type(ExecutionEventType var1);

        public Builder stepName(String var1);

        public Builder executionBlockType(String var1);

        public Builder executionBlockType(ExecutionBlockType var1);

        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);

        public Builder error(String var1);

        public Builder description(String var1);

        public Builder eventId(String var1);

        public Builder previousEventId(String var1);
    }
}

