/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.TestSuiteListCopier;
import software.amazon.awssdk.services.apptest.model.TestSuiteSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestSuitesResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, ListTestSuitesResponse> {
    private static final SdkField<List<TestSuiteSummary>> TEST_SUITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testSuites").getter(ListTestSuitesResponse.getter(ListTestSuitesResponse::testSuites)).setter(ListTestSuitesResponse.setter(Builder::testSuites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuites").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestSuiteSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestSuitesResponse.getter(ListTestSuitesResponse::nextToken)).setter(ListTestSuitesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTestSuitesResponse.memberNameToFieldInitializer();
    private final List<TestSuiteSummary> testSuites;
    private final String nextToken;

    private ListTestSuitesResponse(BuilderImpl builder) {
        super(builder);
        this.testSuites = builder.testSuites;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestSuites() {
        return this.testSuites != null && !(this.testSuites instanceof SdkAutoConstructList);
    }

    public final List<TestSuiteSummary> testSuites() {
        return this.testSuites;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestSuites() ? this.testSuites() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestSuitesResponse)) {
            return false;
        }
        ListTestSuitesResponse other = (ListTestSuitesResponse)((Object)obj);
        return this.hasTestSuites() == other.hasTestSuites() && Objects.equals(this.testSuites(), other.testSuites()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestSuitesResponse").add("TestSuites", this.hasTestSuites() ? this.testSuites() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSuites": {
                return Optional.ofNullable(clazz.cast(this.testSuites()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testSuites", TEST_SUITES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTestSuitesResponse, T> g) {
        return obj -> g.apply((ListTestSuitesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private List<TestSuiteSummary> testSuites = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestSuitesResponse model) {
            super(model);
            this.testSuites(model.testSuites);
            this.nextToken(model.nextToken);
        }

        public final List<TestSuiteSummary.Builder> getTestSuites() {
            List<TestSuiteSummary.Builder> result = TestSuiteListCopier.copyToBuilder(this.testSuites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestSuites(Collection<TestSuiteSummary.BuilderImpl> testSuites) {
            this.testSuites = TestSuiteListCopier.copyFromBuilder(testSuites);
        }

        @Override
        public final Builder testSuites(Collection<TestSuiteSummary> testSuites) {
            this.testSuites = TestSuiteListCopier.copy(testSuites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSuites(TestSuiteSummary ... testSuites) {
            this.testSuites(Arrays.asList(testSuites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSuites(Consumer<TestSuiteSummary.Builder> ... testSuites) {
            this.testSuites(Stream.of(testSuites).map(c -> (TestSuiteSummary)((TestSuiteSummary.Builder)TestSuiteSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestSuitesResponse build() {
            return new ListTestSuitesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestSuitesResponse> {
        public Builder testSuites(Collection<TestSuiteSummary> var1);

        public Builder testSuites(TestSuiteSummary ... var1);

        public Builder testSuites(Consumer<TestSuiteSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

