/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.DataSet;
import software.amazon.awssdk.services.apptest.model.DataSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TN3270StepOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TN3270StepOutput> {
    private static final SdkField<String> DATA_SET_EXPORT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSetExportLocation").getter(TN3270StepOutput.getter(TN3270StepOutput::dataSetExportLocation)).setter(TN3270StepOutput.setter(Builder::dataSetExportLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetExportLocation").build()}).build();
    private static final SdkField<String> DMS_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dmsOutputLocation").getter(TN3270StepOutput.getter(TN3270StepOutput::dmsOutputLocation)).setter(TN3270StepOutput.setter(Builder::dmsOutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dmsOutputLocation").build()}).build();
    private static final SdkField<List<DataSet>> DATA_SET_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSetDetails").getter(TN3270StepOutput.getter(TN3270StepOutput::dataSetDetails)).setter(TN3270StepOutput.setter(Builder::dataSetDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCRIPT_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scriptOutputLocation").getter(TN3270StepOutput.getter(TN3270StepOutput::scriptOutputLocation)).setter(TN3270StepOutput.setter(Builder::scriptOutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptOutputLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_EXPORT_LOCATION_FIELD, DMS_OUTPUT_LOCATION_FIELD, DATA_SET_DETAILS_FIELD, SCRIPT_OUTPUT_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TN3270StepOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSetExportLocation;
    private final String dmsOutputLocation;
    private final List<DataSet> dataSetDetails;
    private final String scriptOutputLocation;

    private TN3270StepOutput(BuilderImpl builder) {
        this.dataSetExportLocation = builder.dataSetExportLocation;
        this.dmsOutputLocation = builder.dmsOutputLocation;
        this.dataSetDetails = builder.dataSetDetails;
        this.scriptOutputLocation = builder.scriptOutputLocation;
    }

    public final String dataSetExportLocation() {
        return this.dataSetExportLocation;
    }

    public final String dmsOutputLocation() {
        return this.dmsOutputLocation;
    }

    public final boolean hasDataSetDetails() {
        return this.dataSetDetails != null && !(this.dataSetDetails instanceof SdkAutoConstructList);
    }

    public final List<DataSet> dataSetDetails() {
        return this.dataSetDetails;
    }

    public final String scriptOutputLocation() {
        return this.scriptOutputLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetExportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dmsOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetDetails() ? this.dataSetDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptOutputLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TN3270StepOutput)) {
            return false;
        }
        TN3270StepOutput other = (TN3270StepOutput)obj;
        return Objects.equals(this.dataSetExportLocation(), other.dataSetExportLocation()) && Objects.equals(this.dmsOutputLocation(), other.dmsOutputLocation()) && this.hasDataSetDetails() == other.hasDataSetDetails() && Objects.equals(this.dataSetDetails(), other.dataSetDetails()) && Objects.equals(this.scriptOutputLocation(), other.scriptOutputLocation());
    }

    public final String toString() {
        return ToString.builder((String)"TN3270StepOutput").add("DataSetExportLocation", (Object)this.dataSetExportLocation()).add("DmsOutputLocation", (Object)this.dmsOutputLocation()).add("DataSetDetails", this.hasDataSetDetails() ? this.dataSetDetails() : null).add("ScriptOutputLocation", (Object)this.scriptOutputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSetExportLocation": {
                return Optional.ofNullable(clazz.cast(this.dataSetExportLocation()));
            }
            case "dmsOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.dmsOutputLocation()));
            }
            case "dataSetDetails": {
                return Optional.ofNullable(clazz.cast(this.dataSetDetails()));
            }
            case "scriptOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.scriptOutputLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSetExportLocation", DATA_SET_EXPORT_LOCATION_FIELD);
        map.put("dmsOutputLocation", DMS_OUTPUT_LOCATION_FIELD);
        map.put("dataSetDetails", DATA_SET_DETAILS_FIELD);
        map.put("scriptOutputLocation", SCRIPT_OUTPUT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TN3270StepOutput, T> g) {
        return obj -> g.apply((TN3270StepOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSetExportLocation;
        private String dmsOutputLocation;
        private List<DataSet> dataSetDetails = DefaultSdkAutoConstructList.getInstance();
        private String scriptOutputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(TN3270StepOutput model) {
            this.dataSetExportLocation(model.dataSetExportLocation);
            this.dmsOutputLocation(model.dmsOutputLocation);
            this.dataSetDetails(model.dataSetDetails);
            this.scriptOutputLocation(model.scriptOutputLocation);
        }

        public final String getDataSetExportLocation() {
            return this.dataSetExportLocation;
        }

        public final void setDataSetExportLocation(String dataSetExportLocation) {
            this.dataSetExportLocation = dataSetExportLocation;
        }

        @Override
        public final Builder dataSetExportLocation(String dataSetExportLocation) {
            this.dataSetExportLocation = dataSetExportLocation;
            return this;
        }

        public final String getDmsOutputLocation() {
            return this.dmsOutputLocation;
        }

        public final void setDmsOutputLocation(String dmsOutputLocation) {
            this.dmsOutputLocation = dmsOutputLocation;
        }

        @Override
        public final Builder dmsOutputLocation(String dmsOutputLocation) {
            this.dmsOutputLocation = dmsOutputLocation;
            return this;
        }

        public final List<DataSet.Builder> getDataSetDetails() {
            List<DataSet.Builder> result = DataSetListCopier.copyToBuilder(this.dataSetDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetDetails(Collection<DataSet.BuilderImpl> dataSetDetails) {
            this.dataSetDetails = DataSetListCopier.copyFromBuilder(dataSetDetails);
        }

        @Override
        public final Builder dataSetDetails(Collection<DataSet> dataSetDetails) {
            this.dataSetDetails = DataSetListCopier.copy(dataSetDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetDetails(DataSet ... dataSetDetails) {
            this.dataSetDetails(Arrays.asList(dataSetDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetDetails(Consumer<DataSet.Builder> ... dataSetDetails) {
            this.dataSetDetails(Stream.of(dataSetDetails).map(c -> (DataSet)((DataSet.Builder)DataSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScriptOutputLocation() {
            return this.scriptOutputLocation;
        }

        public final void setScriptOutputLocation(String scriptOutputLocation) {
            this.scriptOutputLocation = scriptOutputLocation;
        }

        @Override
        public final Builder scriptOutputLocation(String scriptOutputLocation) {
            this.scriptOutputLocation = scriptOutputLocation;
            return this;
        }

        public TN3270StepOutput build() {
            return new TN3270StepOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TN3270StepOutput> {
        public Builder dataSetExportLocation(String var1);

        public Builder dmsOutputLocation(String var1);

        public Builder dataSetDetails(Collection<DataSet> var1);

        public Builder dataSetDetails(DataSet ... var1);

        public Builder dataSetDetails(Consumer<DataSet.Builder> ... var1);

        public Builder scriptOutputLocation(String var1);
    }
}

