/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.M2ManagedRuntime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class M2ManagedApplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, M2ManagedApplication> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(M2ManagedApplication.getter(M2ManagedApplication::applicationId)).setter(M2ManagedApplication.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(M2ManagedApplication.getter(M2ManagedApplication::runtimeAsString)).setter(M2ManagedApplication.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcEndpointServiceName").getter(M2ManagedApplication.getter(M2ManagedApplication::vpcEndpointServiceName)).setter(M2ManagedApplication.setter(Builder::vpcEndpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointServiceName").build()}).build();
    private static final SdkField<String> LISTENER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listenerPort").getter(M2ManagedApplication.getter(M2ManagedApplication::listenerPort)).setter(M2ManagedApplication.setter(Builder::listenerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, RUNTIME_FIELD, VPC_ENDPOINT_SERVICE_NAME_FIELD, LISTENER_PORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = M2ManagedApplication.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String runtime;
    private final String vpcEndpointServiceName;
    private final String listenerPort;

    private M2ManagedApplication(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.runtime = builder.runtime;
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.listenerPort = builder.listenerPort;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final M2ManagedRuntime runtime() {
        return M2ManagedRuntime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final String vpcEndpointServiceName() {
        return this.vpcEndpointServiceName;
    }

    public final String listenerPort() {
        return this.listenerPort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerPort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedApplication)) {
            return false;
        }
        M2ManagedApplication other = (M2ManagedApplication)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.vpcEndpointServiceName(), other.vpcEndpointServiceName()) && Objects.equals(this.listenerPort(), other.listenerPort());
    }

    public final String toString() {
        return ToString.builder((String)"M2ManagedApplication").add("ApplicationId", (Object)this.applicationId()).add("Runtime", (Object)this.runtimeAsString()).add("VpcEndpointServiceName", (Object)this.vpcEndpointServiceName()).add("ListenerPort", (Object)this.listenerPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "vpcEndpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointServiceName()));
            }
            case "listenerPort": {
                return Optional.ofNullable(clazz.cast(this.listenerPort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        map.put("vpcEndpointServiceName", VPC_ENDPOINT_SERVICE_NAME_FIELD);
        map.put("listenerPort", LISTENER_PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedApplication, T> g) {
        return obj -> g.apply((M2ManagedApplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String runtime;
        private String vpcEndpointServiceName;
        private String listenerPort;

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedApplication model) {
            this.applicationId(model.applicationId);
            this.runtime(model.runtime);
            this.vpcEndpointServiceName(model.vpcEndpointServiceName);
            this.listenerPort(model.listenerPort);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(M2ManagedRuntime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getVpcEndpointServiceName() {
            return this.vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final String getListenerPort() {
            return this.listenerPort;
        }

        public final void setListenerPort(String listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(String listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public M2ManagedApplication build() {
            return new M2ManagedApplication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, M2ManagedApplication> {
        public Builder applicationId(String var1);

        public Builder runtime(String var1);

        public Builder runtime(M2ManagedRuntime var1);

        public Builder vpcEndpointServiceName(String var1);

        public Builder listenerPort(String var1);
    }
}

