/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.CreateCloudFormationSummary;
import software.amazon.awssdk.services.apptest.model.DeleteCloudFormationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFormationStepSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFormationStepSummary> {
    private static final SdkField<CreateCloudFormationSummary> CREATE_CLOUDFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("createCloudformation").getter(CloudFormationStepSummary.getter(CloudFormationStepSummary::createCloudformation)).setter(CloudFormationStepSummary.setter(Builder::createCloudformation)).constructor(CreateCloudFormationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createCloudformation").build()}).build();
    private static final SdkField<DeleteCloudFormationSummary> DELETE_CLOUDFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deleteCloudformation").getter(CloudFormationStepSummary.getter(CloudFormationStepSummary::deleteCloudformation)).setter(CloudFormationStepSummary.setter(Builder::deleteCloudformation)).constructor(DeleteCloudFormationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteCloudformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_CLOUDFORMATION_FIELD, DELETE_CLOUDFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createCloudformation", CREATE_CLOUDFORMATION_FIELD);
            this.put("deleteCloudformation", DELETE_CLOUDFORMATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CreateCloudFormationSummary createCloudformation;
    private final DeleteCloudFormationSummary deleteCloudformation;
    private final Type type;

    private CloudFormationStepSummary(BuilderImpl builder) {
        this.createCloudformation = builder.createCloudformation;
        this.deleteCloudformation = builder.deleteCloudformation;
        this.type = builder.type;
    }

    public final CreateCloudFormationSummary createCloudformation() {
        return this.createCloudformation;
    }

    public final DeleteCloudFormationSummary deleteCloudformation() {
        return this.deleteCloudformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createCloudformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteCloudformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationStepSummary)) {
            return false;
        }
        CloudFormationStepSummary other = (CloudFormationStepSummary)obj;
        return Objects.equals(this.createCloudformation(), other.createCloudformation()) && Objects.equals(this.deleteCloudformation(), other.deleteCloudformation());
    }

    public final String toString() {
        return ToString.builder((String)"CloudFormationStepSummary").add("CreateCloudformation", (Object)this.createCloudformation()).add("DeleteCloudformation", (Object)this.deleteCloudformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createCloudformation": {
                return Optional.ofNullable(clazz.cast(this.createCloudformation()));
            }
            case "deleteCloudformation": {
                return Optional.ofNullable(clazz.cast(this.deleteCloudformation()));
            }
        }
        return Optional.empty();
    }

    public static CloudFormationStepSummary fromCreateCloudformation(CreateCloudFormationSummary createCloudformation) {
        return (CloudFormationStepSummary)CloudFormationStepSummary.builder().createCloudformation(createCloudformation).build();
    }

    public static CloudFormationStepSummary fromCreateCloudformation(Consumer<CreateCloudFormationSummary.Builder> createCloudformation) {
        CreateCloudFormationSummary.Builder builder = CreateCloudFormationSummary.builder();
        createCloudformation.accept(builder);
        return CloudFormationStepSummary.fromCreateCloudformation((CreateCloudFormationSummary)builder.build());
    }

    public static CloudFormationStepSummary fromDeleteCloudformation(DeleteCloudFormationSummary deleteCloudformation) {
        return (CloudFormationStepSummary)CloudFormationStepSummary.builder().deleteCloudformation(deleteCloudformation).build();
    }

    public static CloudFormationStepSummary fromDeleteCloudformation(Consumer<DeleteCloudFormationSummary.Builder> deleteCloudformation) {
        DeleteCloudFormationSummary.Builder builder = DeleteCloudFormationSummary.builder();
        deleteCloudformation.accept(builder);
        return CloudFormationStepSummary.fromDeleteCloudformation((DeleteCloudFormationSummary)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationStepSummary, T> g) {
        return obj -> g.apply((CloudFormationStepSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CREATE_CLOUDFORMATION,
        DELETE_CLOUDFORMATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CreateCloudFormationSummary createCloudformation;
        private DeleteCloudFormationSummary deleteCloudformation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationStepSummary model) {
            this.createCloudformation(model.createCloudformation);
            this.deleteCloudformation(model.deleteCloudformation);
        }

        public final CreateCloudFormationSummary.Builder getCreateCloudformation() {
            return this.createCloudformation != null ? this.createCloudformation.toBuilder() : null;
        }

        public final void setCreateCloudformation(CreateCloudFormationSummary.BuilderImpl createCloudformation) {
            CreateCloudFormationSummary oldValue = this.createCloudformation;
            this.createCloudformation = createCloudformation != null ? createCloudformation.build() : null;
            this.handleUnionValueChange(Type.CREATE_CLOUDFORMATION, oldValue, this.createCloudformation);
        }

        @Override
        public final Builder createCloudformation(CreateCloudFormationSummary createCloudformation) {
            CreateCloudFormationSummary oldValue = this.createCloudformation;
            this.createCloudformation = createCloudformation;
            this.handleUnionValueChange(Type.CREATE_CLOUDFORMATION, oldValue, this.createCloudformation);
            return this;
        }

        public final DeleteCloudFormationSummary.Builder getDeleteCloudformation() {
            return this.deleteCloudformation != null ? this.deleteCloudformation.toBuilder() : null;
        }

        public final void setDeleteCloudformation(DeleteCloudFormationSummary.BuilderImpl deleteCloudformation) {
            DeleteCloudFormationSummary oldValue = this.deleteCloudformation;
            this.deleteCloudformation = deleteCloudformation != null ? deleteCloudformation.build() : null;
            this.handleUnionValueChange(Type.DELETE_CLOUDFORMATION, oldValue, this.deleteCloudformation);
        }

        @Override
        public final Builder deleteCloudformation(DeleteCloudFormationSummary deleteCloudformation) {
            DeleteCloudFormationSummary oldValue = this.deleteCloudformation;
            this.deleteCloudformation = deleteCloudformation;
            this.handleUnionValueChange(Type.DELETE_CLOUDFORMATION, oldValue, this.deleteCloudformation);
            return this;
        }

        public CloudFormationStepSummary build() {
            return new CloudFormationStepSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFormationStepSummary> {
        public Builder createCloudformation(CreateCloudFormationSummary var1);

        default public Builder createCloudformation(Consumer<CreateCloudFormationSummary.Builder> createCloudformation) {
            return this.createCloudformation((CreateCloudFormationSummary)((CreateCloudFormationSummary.Builder)CreateCloudFormationSummary.builder().applyMutation(createCloudformation)).build());
        }

        public Builder deleteCloudformation(DeleteCloudFormationSummary var1);

        default public Builder deleteCloudformation(Consumer<DeleteCloudFormationSummary.Builder> deleteCloudformation) {
            return this.deleteCloudformation((DeleteCloudFormationSummary)((DeleteCloudFormationSummary.Builder)DeleteCloudFormationSummary.builder().applyMutation(deleteCloudformation)).build());
        }
    }
}

