/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.CompareAction;
import software.amazon.awssdk.services.apptest.model.MainframeAction;
import software.amazon.awssdk.services.apptest.model.ResourceAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepAction> {
    private static final SdkField<ResourceAction> RESOURCE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceAction").getter(StepAction.getter(StepAction::resourceAction)).setter(StepAction.setter(Builder::resourceAction)).constructor(ResourceAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceAction").build()}).build();
    private static final SdkField<MainframeAction> MAINFRAME_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mainframeAction").getter(StepAction.getter(StepAction::mainframeAction)).setter(StepAction.setter(Builder::mainframeAction)).constructor(MainframeAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mainframeAction").build()}).build();
    private static final SdkField<CompareAction> COMPARE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("compareAction").getter(StepAction.getter(StepAction::compareAction)).setter(StepAction.setter(Builder::compareAction)).constructor(CompareAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compareAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ACTION_FIELD, MAINFRAME_ACTION_FIELD, COMPARE_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceAction", RESOURCE_ACTION_FIELD);
            this.put("mainframeAction", MAINFRAME_ACTION_FIELD);
            this.put("compareAction", COMPARE_ACTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ResourceAction resourceAction;
    private final MainframeAction mainframeAction;
    private final CompareAction compareAction;
    private final Type type;

    private StepAction(BuilderImpl builder) {
        this.resourceAction = builder.resourceAction;
        this.mainframeAction = builder.mainframeAction;
        this.compareAction = builder.compareAction;
        this.type = builder.type;
    }

    public final ResourceAction resourceAction() {
        return this.resourceAction;
    }

    public final MainframeAction mainframeAction() {
        return this.mainframeAction;
    }

    public final CompareAction compareAction() {
        return this.compareAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.mainframeAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.compareAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepAction)) {
            return false;
        }
        StepAction other = (StepAction)obj;
        return Objects.equals(this.resourceAction(), other.resourceAction()) && Objects.equals(this.mainframeAction(), other.mainframeAction()) && Objects.equals(this.compareAction(), other.compareAction());
    }

    public final String toString() {
        return ToString.builder((String)"StepAction").add("ResourceAction", (Object)this.resourceAction()).add("MainframeAction", (Object)this.mainframeAction()).add("CompareAction", (Object)this.compareAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceAction": {
                return Optional.ofNullable(clazz.cast(this.resourceAction()));
            }
            case "mainframeAction": {
                return Optional.ofNullable(clazz.cast(this.mainframeAction()));
            }
            case "compareAction": {
                return Optional.ofNullable(clazz.cast(this.compareAction()));
            }
        }
        return Optional.empty();
    }

    public static StepAction fromResourceAction(ResourceAction resourceAction) {
        return (StepAction)StepAction.builder().resourceAction(resourceAction).build();
    }

    public static StepAction fromResourceAction(Consumer<ResourceAction.Builder> resourceAction) {
        ResourceAction.Builder builder = ResourceAction.builder();
        resourceAction.accept(builder);
        return StepAction.fromResourceAction((ResourceAction)builder.build());
    }

    public static StepAction fromMainframeAction(MainframeAction mainframeAction) {
        return (StepAction)StepAction.builder().mainframeAction(mainframeAction).build();
    }

    public static StepAction fromMainframeAction(Consumer<MainframeAction.Builder> mainframeAction) {
        MainframeAction.Builder builder = MainframeAction.builder();
        mainframeAction.accept(builder);
        return StepAction.fromMainframeAction((MainframeAction)builder.build());
    }

    public static StepAction fromCompareAction(CompareAction compareAction) {
        return (StepAction)StepAction.builder().compareAction(compareAction).build();
    }

    public static StepAction fromCompareAction(Consumer<CompareAction.Builder> compareAction) {
        CompareAction.Builder builder = CompareAction.builder();
        compareAction.accept(builder);
        return StepAction.fromCompareAction((CompareAction)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StepAction, T> g) {
        return obj -> g.apply((StepAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RESOURCE_ACTION,
        MAINFRAME_ACTION,
        COMPARE_ACTION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ResourceAction resourceAction;
        private MainframeAction mainframeAction;
        private CompareAction compareAction;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StepAction model) {
            this.resourceAction(model.resourceAction);
            this.mainframeAction(model.mainframeAction);
            this.compareAction(model.compareAction);
        }

        public final ResourceAction.Builder getResourceAction() {
            return this.resourceAction != null ? this.resourceAction.toBuilder() : null;
        }

        public final void setResourceAction(ResourceAction.BuilderImpl resourceAction) {
            ResourceAction oldValue = this.resourceAction;
            this.resourceAction = resourceAction != null ? resourceAction.build() : null;
            this.handleUnionValueChange(Type.RESOURCE_ACTION, oldValue, this.resourceAction);
        }

        @Override
        public final Builder resourceAction(ResourceAction resourceAction) {
            ResourceAction oldValue = this.resourceAction;
            this.resourceAction = resourceAction;
            this.handleUnionValueChange(Type.RESOURCE_ACTION, oldValue, this.resourceAction);
            return this;
        }

        public final MainframeAction.Builder getMainframeAction() {
            return this.mainframeAction != null ? this.mainframeAction.toBuilder() : null;
        }

        public final void setMainframeAction(MainframeAction.BuilderImpl mainframeAction) {
            MainframeAction oldValue = this.mainframeAction;
            this.mainframeAction = mainframeAction != null ? mainframeAction.build() : null;
            this.handleUnionValueChange(Type.MAINFRAME_ACTION, oldValue, this.mainframeAction);
        }

        @Override
        public final Builder mainframeAction(MainframeAction mainframeAction) {
            MainframeAction oldValue = this.mainframeAction;
            this.mainframeAction = mainframeAction;
            this.handleUnionValueChange(Type.MAINFRAME_ACTION, oldValue, this.mainframeAction);
            return this;
        }

        public final CompareAction.Builder getCompareAction() {
            return this.compareAction != null ? this.compareAction.toBuilder() : null;
        }

        public final void setCompareAction(CompareAction.BuilderImpl compareAction) {
            CompareAction oldValue = this.compareAction;
            this.compareAction = compareAction != null ? compareAction.build() : null;
            this.handleUnionValueChange(Type.COMPARE_ACTION, oldValue, this.compareAction);
        }

        @Override
        public final Builder compareAction(CompareAction compareAction) {
            CompareAction oldValue = this.compareAction;
            this.compareAction = compareAction;
            this.handleUnionValueChange(Type.COMPARE_ACTION, oldValue, this.compareAction);
            return this;
        }

        public StepAction build() {
            return new StepAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepAction> {
        public Builder resourceAction(ResourceAction var1);

        default public Builder resourceAction(Consumer<ResourceAction.Builder> resourceAction) {
            return this.resourceAction((ResourceAction)((ResourceAction.Builder)ResourceAction.builder().applyMutation(resourceAction)).build());
        }

        public Builder mainframeAction(MainframeAction var1);

        default public Builder mainframeAction(Consumer<MainframeAction.Builder> mainframeAction) {
            return this.mainframeAction((MainframeAction)((MainframeAction.Builder)MainframeAction.builder().applyMutation(mainframeAction)).build());
        }

        public Builder compareAction(CompareAction var1);

        default public Builder compareAction(Consumer<CompareAction.Builder> compareAction) {
            return this.compareAction((CompareAction)((CompareAction.Builder)CompareAction.builder().applyMutation(compareAction)).build());
        }
    }
}

