/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.TestCaseListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestCases
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestCases> {
    private static final SdkField<List<String>> SEQUENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sequential").getter(TestCases.getter(TestCases::sequential)).setter(TestCases.setter(Builder::sequential)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequential").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENTIAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sequential", SEQUENTIAL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> sequential;
    private final Type type;

    private TestCases(BuilderImpl builder) {
        this.sequential = builder.sequential;
        this.type = builder.type;
    }

    public final boolean hasSequential() {
        return this.sequential != null && !(this.sequential instanceof SdkAutoConstructList);
    }

    public final List<String> sequential() {
        return this.sequential;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSequential() ? this.sequential() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCases)) {
            return false;
        }
        TestCases other = (TestCases)obj;
        return this.hasSequential() == other.hasSequential() && Objects.equals(this.sequential(), other.sequential());
    }

    public final String toString() {
        return ToString.builder((String)"TestCases").add("Sequential", this.hasSequential() ? this.sequential() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sequential": {
                return Optional.ofNullable(clazz.cast(this.sequential()));
            }
        }
        return Optional.empty();
    }

    public static TestCases fromSequential(List<String> sequential) {
        return (TestCases)TestCases.builder().sequential(sequential).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestCases, T> g) {
        return obj -> g.apply((TestCases)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SEQUENTIAL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<String> sequential = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TestCases model) {
            this.sequential(model.sequential);
        }

        public final Collection<String> getSequential() {
            if (this.sequential instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sequential;
        }

        public final void setSequential(Collection<String> sequential) {
            List<String> oldValue = this.sequential;
            this.sequential = TestCaseListCopier.copy(sequential);
            this.handleUnionValueChange(Type.SEQUENTIAL, oldValue, this.sequential);
        }

        @Override
        public final Builder sequential(Collection<String> sequential) {
            List<String> oldValue = this.sequential;
            this.sequential = TestCaseListCopier.copy(sequential);
            this.handleUnionValueChange(Type.SEQUENTIAL, oldValue, this.sequential);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sequential(String ... sequential) {
            this.sequential(Arrays.asList(sequential));
            return this;
        }

        public TestCases build() {
            return new TestCases(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestCases> {
        public Builder sequential(Collection<String> var1);

        public Builder sequential(String ... var1);
    }
}

